/**

 */

wideload.TentacleShader = {

	uniforms: {

		"delta":   { type: "f", value: 0.005 },

	},

	vertexShader: [

		"varying vec3 vNormal;",
		"uniform float delta;",
		"uniform float collapse;",
		"uniform float distance;",
		"void main() {",

			"vNormal = normal;",
			"vec3 p = position;",
			"//float length = length(p-origin);",
			"p.z += sin(delta*(distance+10.0)/60.0)*distance/6.0;",
			"p.x += sin(delta*(distance+10.0)/100.0+7.0)*distance/8.0;",
			"p.y += cos(delta*(distance+10.0)/50.0)*distance/8.0;",
			
			
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( p, 1.0 );",

		"}"

	].join("\n"),

	fragmentShader: [

		"varying vec3 vNormal;",
		"uniform float rm;",
		"uniform float gm;",
		"uniform float bm;",
		"uniform float distance;",

		"void main() {",
			"vec3 light = vec3(0.4,0.1,0.2);",
			"light = normalize(light);",
			"float dProd = abs(dot(vNormal, light));",
			"gl_FragColor = vec4(rm*dProd, gm*dProd, bm*dProd, 1.0);",

		"}"

	].join("\n")

};
