//Namespace
this.wideload = this.wideload || {};

/**
* Part 2 
*/

(function(){

	
	/**
	* Constructor
	* @param beginTime When the effect should start
	* @param prepareTime How long should the effect be allowed to stay in prepare phase (visible during previous parts end phase).
	         Value of 0 indicates immediate change. The endtime for previous part is the same as this parts prepare. First part has no prepare.
	*/
	var MoluCube = function(beginTime, prepareTime, main){
		this.beginTime = beginTime;
		this.prepareTime = prepareTime;
		this.renderer = null; //Renderer is given from outside.
		this.main = main;
		this.curPos = 0;
		
	}
	
	//Expose class
	wideload.MoluCube = MoluCube;
	
	var p = MoluCube.prototype = new wideload.BasePart();
	
	/**
	* Initialize the part. This is called during page load.
	*/
	p.initialize_Super = p.initialize;
	p.initialize = function(){
		this.initialize_Super();
		this.scene.remove(this.camera);
		this.camera = new THREE.PerspectiveCamera( 45, this.width / this.height);
		this.camera.position.z = 140;
		this.camera.position.x = 0;
		this.camera.position.y = 0;
		this.scene.add(this.camera);
		
		this.uniforms = {
			delta: {type: 'f', value:0.0},
			rm: {type: 'f', value:0},
			gm: {type: 'f', value:0},			
			bm: {type: 'f', value:0},
			size: {type: 'f', value:0}
		};
		//this.material = new THREE.MeshBasicMaterial({color:0x00FF00});
		/*
		this.ball = new THREE.Mesh(new THREE.SphereGeometry(wideload.Main.RESOLUTION[0]/10, 32, 32), material);
			this.ball.position.z = -wideload.Main.RESOLUTION[0]/10;
			this.scene.add(this.ball);
		*/
		
		var instructions = [];
		instructions["m"] = [
		[0,0,0,0,0,0,0,0,0],[0,1,1,1,0,1,1,1,0],[0,1,1,1,1,1,1,1,0],[0,1,1,1,1,1,1,1,0],[0,1,1,0,1,0,1,1,0],[0,1,1,0,0,0,1,1,0],[0,1,1,0,0,0,1,1,0],[0,1,1,0,0,0,1,1,0],[0,0,0,0,0,0,0,0,0]		
		];
		instructions["o"] = [
		[0,0,0,0,0,0,0,0,0],[0,1,1,1,1,1,1,1,0],[0,1,1,1,1,1,1,1,0],[0,1,1,0,0,0,1,1,0],[0,1,1,0,0,0,1,1,0],[0,1,1,0,0,0,1,1,0],[0,1,1,1,1,1,1,1,0],[0,1,1,1,1,1,1,1,0],[0,0,0,0,0,0,0,0,0]
		];
		instructions["l"] = [
		[0,0,0,0,0,0,0,0,0],[0,1,1,0,0,0,0,0,0],[0,1,1,0,0,0,0,0,0],[0,1,1,0,0,0,0,0,0],[0,1,1,0,0,0,0,0,0],[0,1,1,0,0,0,0,0,0],[0,1,1,1,1,1,1,0,0],[0,1,1,1,1,1,1,0,0],[0,0,0,0,0,0,0,0,0]		
		];
		instructions["u"] = [
		[0,0,0,0,0,0,0,0,0],[0,1,1,0,0,0,1,1,0],[0,1,1,0,0,0,1,1,0],[0,1,1,0,0,0,1,1,0],[0,1,1,0,0,0,1,1,0],[0,1,1,0,0,0,1,1,0],[0,1,1,1,1,1,1,1,0],[0,1,1,1,1,1,1,1,0],[0,0,0,0,0,0,0,0,0]		
		];
		instructions["c"] = [
		[0,0,0,0,0,0,0,0,0],[0,1,1,1,1,1,1,1,0],[0,1,1,1,1,1,1,1,0],[0,1,1,0,0,0,0,0,0],[0,1,1,0,0,0,0,0,0],[0,1,1,0,0,0,0,0,0],[0,1,1,1,1,1,1,1,0],[0,1,1,1,1,1,1,1,0],[0,0,0,0,0,0,0,0,0]		
		];
		instructions["b"] = [
		[0,0,0,0,0,0,0,0,0],[0,1,1,1,1,1,1,0,0],[0,1,1,0,0,0,1,1,0],[0,1,1,0,0,0,1,1,0],[0,1,1,1,1,1,1,1,0],[0,1,1,0,0,0,1,1,0],[0,1,1,0,0,0,1,1,0],[0,1,1,1,1,1,1,0,0],[0,0,0,0,0,0,0,0,0]		
		];
		instructions["e"] = [
		[0,0,0,0,0,0,0,0,0],[0,1,1,1,1,1,0,1,0],[0,1,1,0,0,0,0,1,0],[0,1,1,0,0,0,0,1,0],[0,1,1,1,1,1,0,1,0],[0,1,1,0,0,0,0,1,0],[0,1,1,0,0,0,0,0,0],[0,1,1,1,1,1,0,1,0],[0,0,0,0,0,0,0,0,0]		
		];
		instructions[" "] = [
		[1,1,1,1,1,1,1,1,1],[1,0,0,0,0,0,0,0,1],[1,0,0,0,0,0,0,0,1],[1,0,0,0,0,0,0,0,1],[1,0,0,0,0,0,0,0,1],[1,0,0,0,0,0,0,0,1],[1,0,0,0,0,0,0,0,1],[1,0,0,0,0,0,0,0,1],[1,1,1,1,1,1,1,1,1]
		]
		
		this.exp = [
			[0,0,0]/*,
			[-1,0,0],
			[1,0,0,],
			[0,1,0],
			[0,-1,0],
			[0,0,1],
			[0,0,-1]*/
		
		];
		
		this.blows = [
			[4,-4,0],
			[4,-3,0],
			[4,-2,0],
			[4,-1,0],
			[4,-0,0],

			[4, 0,1],
			[4,-1,1],
			[4,-2,1],
			[4,-3,1],
			[4,-4,1],

			[4,-4,-1],
			[4,-4,-2],
			[4,-4,-3],
			[4,-4,-4],

			[4,-3,-4],

			[4,-2,-4],
			[4,-1,-4],
			[4,-0,-4],
			[4, 1,-4],
			[4, 2,-4],
			[4, 3,-4],
			[4,4,-4],

			[4,4,-3],
			[4,4,-2],
			[4,4,-1],
			[4,4,-0],
			[4,4, 1],
			
			[4,3, 1],
			[4,3, 0],
			[4,2, 0],
			[4,2, 1],
			[4,1, 1],
			[4,1, 2],
			[4,1, 3],
			[4,1, 4],

			[4, 0, 4],
			[4,-1, 4],
			[4,-2, 4],
			[4,-3, 4],
			[4,-4, 4],

			[4,-4, 4],
			[3,-4, 4],
			[2,-4, 4],
			[1,-4, 4],
			[0,-4, 4],
			[-1,-4, 4],
			[-2,-4, 4],
			[-3,-4, 4],
			[-4,-4, 4],

			[-4,-3, 4],
			[-3,-3, 4],
			[-2,-3, 4],
			[-1,-3, 4],
			[-0,-3, 4],
			[ 1,-3, 4],
			[ 2,-3, 4],
			[ 3,-3, 4],

			[ 3,-2, 4],
			[ 2,-2, 4],
			[ 1,-2, 4],
			[-0,-2, 4],
			[-1,-2, 4],
			[-2,-2, 4],
			[-3,-2, 4],
			[-4,-2, 4],

			[-4,-1, 4],
			[-3,-1, 4],
			[-2,-1, 4],
			[-1,-1, 4],
			[-0,-1, 4],
			[ 1,-1, 4],
			[ 2,-1, 4],
			[ 3,-1, 4],

			[ 3, 0, 4],
			[ 2, 0, 4],
			[ 1, 0, 4],
			[-0, 0, 4],
			[-1, 0, 4],
			[-2, 0, 4],
			[-3, 0, 4],
			[-4, 0, 4],

			[-4, 1, 4],
			[-3, 1, 4],
			[-2, 1, 4],
			[-1, 1, 4],
			[-0, 1, 4],
			[ 1, 1, 4],
			[ 2, 1, 4],
			[ 3, 1, 4],

			[ 3, 2, 4],
			[ 2, 2, 4],
			[ 1, 2, 4],
			[-0, 2, 4],
			[-1, 2, 4],
			[-2, 2, 4],
			[-3, 2, 4],
			[-4, 2, 4],

			[-4, 3, 4],
			[-3, 3, 4],
			[-2, 3, 4],
			[-1, 3, 4],
			[-0, 3, 4],
			[ 1, 3, 4],
			[ 2, 3, 4],
			[ 3, 3, 4],

			[ 3, 4, 4],
			[ 2, 4, 4],
			[ 1, 4, 4],
			[-0, 4, 4],
			[-1, 4, 4],
			[-2, 4, 4],
			[-3, 4, 4],
			[-4, 4, 4],

			[-4, 4, 3],
			[-3, 4, 3],
			[-2, 4, 3],
			[-1, 4, 3],
			[-0, 4, 3],
			[ 1, 4, 3],
			[ 2, 4, 3],
			[ 3, 4, 3],
			[ 4, 4, 3],

			[ 4, 4, 3],
			[ 4, 3, 3],
			[ 4, 2, 3],

			[ 4, 2, 4],
			[ 4, 3, 4],
			[ 4, 4, 4],

			[ 4, 4, 3],
			[ 4, 4, 2],
			[ 4, 3, 2],
			[ 4, 2, 2],

			[ 4, 1, 2],
			[ 4, 0, 2],
			[ 4,-1, 2],
			[ 4,-2, 2],
			[ 4,-3, 2],
			[ 4,-4, 2],

			[ 4,-4, 3],
			[ 4,-3, 3],
			[ 4,-2, 3],
			[ 4,-1, 3],
			[ 4, 0, 3],
			[ 4, 1, 3],

			[ 4, 1, 2],
			[ 4, 1, 1],
			[ 4, 1, 0],
			[ 4, 1,-1],

			[ 4, 2,-1],
			[ 4, 3,-1],
			[ 4, 4,-1],

			[ 4, 4,-2],
			[ 4, 4,-3],
			[ 4, 4,-4],

			[ 3, 4,-4],
			[ 2, 4,-4],
			[ 1, 4,-4],
			[ 0, 4,-4],
			[-1, 4,-4],
			[-2, 4,-4],
			[-3, 4,-4],
			[-4, 4,-4],

			[-4, 4,-3],
			[-4, 4,-2],
			[-4, 4,-1],
			[-4, 4, 0],
			[-4, 4, 1],
			[-4, 4, 2],

			[-3, 4, 2],
			[-2, 4, 2],
			[-1, 4, 2],
			[-0, 4, 2],
			[ 1, 4, 2],
			[ 2, 4, 2],
			[ 3, 4, 2],

			[ 3, 4, 1],
			[ 3, 4, 0],
			[ 3, 4,-1],
			[ 3, 4,-2],
			[ 3, 4,-3],
			
			[ 2, 4,-3],
			[ 1, 4,-3],
			[ 0, 4,-3],
			[-1, 4,-3],
			[-2, 4,-3],
			[-3, 4,-3],

			[-3, 4,-2],
			[-3, 4,-1],
			[-3, 4,-0],
			[-3, 4, 1],

			[-2, 4, 1],
			[-1, 4, 1],
			[-0, 4, 1],
			[ 1, 4, 1],
			[ 2, 4, 1],
			
			[ 2, 4, 0],
			[ 2, 4,-1],
			[ 2, 4,-2],
			
			[ 1, 4,-2],
			[ 0, 4,-2],
			[ -1, 4,-2],
			[-2, 4,-2],

			[-2, 4,-1],
			[-2, 4,-0],
			[-2, 4, 1],
			[-1, 4, 1],
			[-1, 4, 0],
			[-1, 4, -1],
			[0, 4, -1],
			[0, 4, -0],
			[0, 4,  1],
			[1, 4,  1],
			[1, 4,  0],
			[1, 4,  -1],
			
			[1, 4,  -1],
			[1, 4,  -2],
			[1, 4,  -3],
			[1, 4,  -4],
			
			[1, 3,  -4],
			[1, 2,  -4],
			[1, 1,  -4],
			[1, 0,  -4],
			[1,-1,  -4],
			[1,-2,  -4],
			[1,-3,  -4],
			[1,-4,  -4],
		
			[2,-4,  -4],
			[2,-3,  -4],
			[2,-2,  -4],
			[2,-1,  -4],
			[2,-0,  -4],
			[2,1,  -4],
			[2,2,  -4],
			[2,3,  -4],

			[3,3,  -4],
			[3,2,  -4],
			[3,1,  -4],
			[3,0,  -4],
			[3,-1,  -4],
			[3,-2,  -4],
			[3,-3,  -4],
			[3,-4,  -4],

			[4,-4,  -4],			
			[4,-4,  -3],
			[4,-3,  -3],
			[4,-2,  -3],
			[4,-1,  -3],
			[4,-0,  -3],
			[4, 1,  -3],
			[4, 2,  -3],
			[4, 3,  -3],
			
			[4, 3,  -2],
			[4, 2,  -2],
			[4, 1,  -2],
			[4, 0,  -2],
			[4, 0,  -1],
			[4, -1,  -1],
			[4, -1,  -2],
			[4, -2,  -2],
			[4, -2,  -1],
			[4, -3,  -1],
			[4, -3,  -2],
			
			[4, -3,  -3],
			[4, -3,  -4],
			[3, -3,  -4],
			[2, -3,  -4],
			[1, -3,  -4],
			
			[1, -4,  -4],
			[1, -4,  -3],
			[1, -4,  -2],
			[1, -4,  -1],
			[1, -4,  -0],
			[1, -4,  1],
			[1, -4,  2],
			[1, -4,  3],
			
			[2, -4,  3],
			[3, -4,  3],
			[3, -4,  2],
			[3, -4,  1],
			[3, -4,  0],
			[3, -4, -1],
			[3, -4, -2],
			[3, -4, -3],
			
			[2, -4, -3],
			[2, -4, -2],
			[2, -4, -1],
			[2, -4, -0],
			[2, -4, 1],
			[2, -4, 2],
			[2, -4, 3],
			
			[1, -4, 3],
			[0, -4, 3],
			[-1, -4, 3],
			[-2, -4, 3],
			[-3, -4, 3],
			
			[-3, -4, 2],
			[-3, -4, 1],
			[-3, -4, 0],
			[-3, -4, -1],
			[-3, -4, -2],
			[-3, -4, -3],

			[-2, -4, -3],
			[-2, -4, -2],
			[-2, -4, -1],
			[-2, -4, -0],
			[-2, -4, 1],
			[-2, -4, 2],
			
			[-1, -4, 2],
			[-1, -4, 1],
			[-1, -4, 0],
			[-1, -4, -1],
			[-1, -4, -2],
			[-1, -4, -3],

			[0, -4, -3],
			[0, -4, -2],
			[0, -4, -1],
			[0, -4, -0],
			[0, -4, 1],
			[0, -4, 2],
			
			[1, -4, 2],
			[1, -4, 1],
			[1, -4, 0],
			[1, -4, -1],
			[1, -4, -2],
			[1, -4, -3],
			[1, -4, -4],

			[0, -4, -4],
			[-1, -4, -4],
			[-2, -4, -4],
			[-3, -4, -4],
			[-4, -4, -4],

			[-4, -3, -4],
			[-3, -3, -4],
			[-2, -3, -4],
			[-1, -3, -4],
			[0, -3, -4],

			[0, -2, -4],
			[-1, -2, -4],
			[-2, -2, -4],
			[-3, -2, -4],

			[-3, -1, -4],
			[-2, -1, -4],
			[-1, -1, -4],
			[-0, -1, -4],

			[-0, -0, -4],
			[-1, -0, -4],
			[-2, -0, -4],
			[-3, -0, -4],

			[-3, 1, -4],
			[-2, 1, -4],
			[-1, 1, -4],
			[0, 1, -4],

			[-0, 2, -4],
			[-1, 2, -4],
			[-2, 2, -4],
			[-3, 2, -4],

			[-3, 3, -4],
			[-2, 3, -4],
			[-1, 3, -4],
			[0, 3, -4],
			[-1, 3, -4],
			[-2, 3, -4],
			[-3, 3, -4],
			[-4, 3, -4],

			[-4, 3, -4],
			[-4, 3, -3],
			[-4, 3, -2],
			[-4, 3, -1],
			[-4, 3, -0],
			[-4, 3, 1],
			[-4, 3, 2],
			[-4, 3, 3],
			
			[-4, 2, 3],
			[-4, 2, 2],
			[-4, 2, 1],
			[-4, 2, 0],
			[-4, 2, -1],
			[-4, 2, -2],
			[-4, 2, -3],
			[-4, 2, -4],

			[-4, 1, -4],
			[-4, 1, -3],
			[-4, 1, -2],
			[-4, 1, -1],
			[-4, 1, -0],
			[-4, 1, 1],
			[-4, 1, 2],
			[-4, 1, 3],

			[-4, 0, 3],
			[-4, 0, 2],
			[-4, 0, 1],
			[-4, 0, 0],
			[-4, 0, -1],
			[-4, 0, -2],
			[-4, 0, -3],
			[-4, 0, -4],

			[-4, -1, -4],
			[-4, -1, -3],
			[-4, -1, -2],
			[-4, -1, -1],
			[-4, -1, -0],
			[-4, -1, 1],
			[-4, -1, 2],
			[-4, -1, 3],
			[-4, -2, 3],

			[-4, -2, 3],
			[-4, -2, 2],
			[-4, -2, 1],
			[-4, -2, 0],
			[-4, -2, -1],
			[-4, -2, -2],
			[-4, -2, -3],
			[-4, -2, -4],

			[-4, -3, -4],
			[-4, -3, -3],
			[-4, -3, -2],
			[-4, -3, -1],
			[-4, -3, -0],
			[-4, -3, 1],
			[-4, -3, 2],
			[-4, -3, 3],

			[-4, -4, 3],
			[-4, -4, 2],
			[-4, -4, 1],
			[-4, -4, 0],
			[-4, -4, -1],
			[-4, -4, -2],
			[-4, -4, -3],
			
		]
		
		this.ctx = 0;
		this.cty = 0;
		this.ctz = 0;
		
		this.blowIndex = 0;
		this.instructions = instructions;
		this.text = "molucube     ";
		this.textInd = 0;
		var colors = [0x90900, 0xAAAA00, 0xEEEE00, 0xFFFF00, 0xFFFF00];
		var cubeGeo = new THREE.CubeGeometry(10,10,10);
		var material = new THREE.MeshBasicMaterial({color:0x000000});
		var cube = new THREE.Mesh(cubeGeo, material);
		this.scene.add(cube);
		this.cubes=[];
		this.particles = [];
		for(var i = -4; i < 5; i++)
		{
			this.cubes[i] = [];
			this.particles[i] = [];
			for(var j = -4; j < 5; j++)
			{
				this.cubes[i][j] = [];
				this.particles[i][j] = [];
				
				for(var k = -4; k < 5; k++)
				{
					this.cubes[i][j][k] = null;
					this.particles[i][j][k] = null;
				}
			}
		}
		this.cubes[0][0][0] = cube;
		this.actualcubes = [];
		for(var k = 1; k < 5; k++)
		{
			//Z var
			for(var o = 0-k; o <= k; o++)
			{
			//y
				for(var i = 0-k; i <= k; i++)
				{
				//X
					for(var j = 0-k; j <= k; j++)
					{
						if(this.cubes[o][i][j] == null)
						{
							var material = new THREE.MeshBasicMaterial({color:colors[k]});
							var cube = new THREE.Mesh(cubeGeo, material);
							this.cubes[o][i][j] = cube;
							this.scene.add(cube);
							cube.position.x = j*10;
							cube.position.y = i*10;
							cube.position.z = o*10;
							this.actualcubes.push(cube);
							/*var partMaterial = new THREE.ParticleBasicMaterial({
								color: 0xFFFFFF,
								size: 1,
								blending: THREE.AdditiveBlending,
								transparent: true
							  });
							var partSys = new THREE.ParticleSystem(partGeom, material);
							this.particles[o][i][j] = partSys;*/
							//partSys.position.x = j*10;
						//	partSys.position.y = i*10;
						//	partSys.position.z = o*10;
							
							
						}
					}
				}
			}
		}
		
		var cubeGeo = new THREE.CubeGeometry(6,6,6);
		var material = new THREE.MeshBasicMaterial({color:0x000000});
		var cube = new THREE.Mesh(cubeGeo, material);
		//this.scene.add(cube);
		this.faceCubes=[];
		this.particles = [];
		for(var i = -4; i < 5; i++)
		{
			this.faceCubes[i] = [];
			this.particles[i] = [];
			for(var j = -4; j < 5; j++)
			{
				this.faceCubes[i][j] = [];
				this.particles[i][j] = [];
				
				for(var k = -4; k < 5; k++)
				{
					this.faceCubes[i][j][k] = null;
					this.particles[i][j][k] = null;
				}
			}
		}
		this.faceCubes[0][0][0] = cube;
		this.actualFcubes = [];
		for(var k = 1; k < 5; k++)
		{
			//Z var
			for(var o = 0-k; o <= k; o++)
			{
			//y
				for(var i = 0-k; i <= k; i++)
				{
				//X
					for(var j = 0-k; j <= k; j++)
					{
						if(this.faceCubes[o][i][j] == null)
						{
							var material = new THREE.MeshBasicMaterial({color:(
							j==4 && o==4 || 
							j==4 && o==-4 || 
							j==4 && i==-4 || 
							j==4 && i==4 || 
							j ==-4 && o==-4 ||
							j ==-4 && o==4 ||
 							j ==-4 && i==4 ||
 							j ==-4 && i==-4 ||
 							i == 4 && o==4 || 
							i == -4 && o==4 || 
							i == 4 && o==-4 || 
							i == -4 && o==-4 
							) ? 0xFFFFFF : 0});
							var cube = new THREE.Mesh(cubeGeo, material);
							this.faceCubes[o][i][j] = cube;
							this.scene.add(cube);
							cube.visible = false;
							cube.position.x = j*6;
							cube.position.y = i*6;
							cube.position.z = o*6;
							this.actualFcubes.push(cube);
							/*var partMaterial = new THREE.ParticleBasicMaterial({
								color: 0xFFFFFF,
								size: 1,
								blending: THREE.AdditiveBlending,
								transparent: true
							  });
							var partSys = new THREE.ParticleSystem(partGeom, material);
							this.particles[o][i][j] = partSys;*/
							//partSys.position.x = j*10;
						//	partSys.position.y = i*10;
						//	partSys.position.z = o*10;
							
							
						}
					}
				}
			}
		}
		
		
		/*
		colors = [0xFF0000, 0x00FF00, 0x0000FF, 0x00FFFF, 0xFFFF00, 0xFFFFFF,0xFF0000];
		for(var k = -3; k <= 6; k++)
		{
			for(var i = -3; i <= 6; i++)
			{
				for(var j = -3; j <= 6; j++)
				{
					var color = 0;
					//First outer layer
					
					var vec3 = new THREE.Vector3(k,i,j);
					var l = vec3.lengthSq();
					color = colors[l];
					console.log(l);
					var material = new THREE.MeshBasicMaterial({color:0x000000});
					var cube = new THREE.Mesh(cubeGeo, material);
					this.scene.add(cube);
					
					cube.position.x = i*10-35;
					cube.position.y = j*10-35;
					cube.position.z = k*10-35;
				}
			}
		}*/
		this.dotScreenEffect = new THREE.ShaderPass(THREE.RGBShiftShader);
		this.dotScreenEffect.uniforms['amount'].value = 0.0;
		
		this.composer = new THREE.EffectComposer(this.main.renderer,this.renderTarget);
		this.composer.addPass(new THREE.RenderPass(this.scene, this.camera));
		this.composer.addPass(this.dotScreenEffect);
		this.fadeout=[];
	}
	
	/**
	* Prepare the part for coming up next. This is called when previous effect notifies the main controller it is ready to end.
	* @param previous Previous part.
	*/
	p.prepare = function(elapsedtime,previous){
		document.getElementById("greets").style.display = "block";
		this.previous = 0;
		this.main.renderer.setClearColor(0x000000);
	}
	
	/**
	* Previous effect has stopped playback. Start playback part.
	*/
	p.begin = function(elapsedtime){
		this.startTime = elapsedtime;
		this.realStart = elapsedtime;
		this.faded = false;
		this.extraDelta = 0;
		this.remove = 0;
		this.previous=elapsedtime;
		this.count = 10;
		this.previousBlow = elapsedtime;this.textInd = this.text.length-3;
	}
	
	/**
	* Pre render action if required
	*/
	p.preRender = function(elapsedtime, td){
		this.uniforms.delta.value+=0.05*td;
		if(elapsedtime - this.startTime < 1000)
		{
			this.camera.position.x = Math.sin(this.count/80)*Math.PI*2*30;
		this.camera.position.y = Math.cos(this.count/40)*Math.PI*2*30;
		
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		var td = (elapsedtime - this.startTime) / 1000;
		var col = 0xff*td;
		col = col << 16 | col <<8  | col;
		for(var i = -4; i < 5; i++)
			{
				for(var j = -4; j < 5; j++)
				{
			if(this.cubes[4][i][j] != null)
				this.cubes[4][i][j].material.color = new THREE.Color(this.instructions[" "][4-i][j+4]==0?0:col);
			if(this.cubes[-4][i][j] != null)
				this.cubes[-4][i][j].material.color = new THREE.Color(this.instructions[" "][4-i][j+4]==0?0:col);
			if(this.cubes[i][4][j] != null)
				this.cubes[i][4][j].material.color = new THREE.Color(this.instructions[" "][4-i][j+4]==0?0:col);
			if(this.cubes[i][-4][j] != null)
				this.cubes[i][-4][j].material.color = new THREE.Color(this.instructions[" "][4-i][j+4]==0?0:col);
			if(this.cubes[i][j][-4] != null)
				this.cubes[i][j][-4].material.color = new THREE.Color(this.instructions[" "][4-i][j+4]==0?0:col);
			if(this.cubes[i][j][4] != null)
				this.cubes[i][j][4].material.color = new THREE.Color(this.instructions[" "][4-i][j+4]==0?0:col);
			}}
			
		}
		if(elapsedtime - this.startTime < 10000 && elapsedtime- this.startTime > 1000)
		{
		this.camera.position.x = Math.sin(this.count/80)*Math.PI*2*30;
		this.camera.position.y = Math.cos(this.count/40)*Math.PI*2*30;
		//	this.camera.position.z = Math.sin(this.count/70)*Math.PI*2*50;
			this.camera.lookAt(new THREE.Vector3(0,0,0));
		if( elapsedtime - this.previous > 200)
		{
			this.textInd = (this.textInd+1)%this.text.length;
			this.previous = elapsedtime;
			
			for(var i = -4; i < 5; i++)
			{
				for(var j = -4; j < 5; j++)
				{
				if(this.cubes[4][i][j] != null)
					this.cubes[4][i][j].material.color = new THREE.Color(this.instructions[this.text.charAt(this.textInd)][4-i][j+4]==0?0:0xFFFFFF);
				if(this.cubes[-4][i][j] != null)
					this.cubes[-4][i][j].material.color = new THREE.Color(this.instructions[this.text.charAt(this.textInd)][4-i][j+4]==0?0:0xFFFFFF);
				if(this.cubes[i][4][j] != null)
					this.cubes[i][4][j].material.color = new THREE.Color(this.instructions[this.text.charAt(this.textInd)][4-i][j+4]==0?0:0xFFFFFF);
				if(this.cubes[i][-4][j] != null)
					this.cubes[i][-4][j].material.color = new THREE.Color(this.instructions[this.text.charAt(this.textInd)][4-i][j+4]==0?0:0xFFFFFF);
				if(this.cubes[i][j][-4] != null)
					this.cubes[i][j][-4].material.color = new THREE.Color(this.instructions[this.text.charAt(this.textInd)][4-i][j+4]==0?0:0xFFFFFF);
				if(this.cubes[i][j][4] != null)
					this.cubes[i][j][4].material.color = new THREE.Color(this.instructions[this.text.charAt(this.textInd)][4-i][j+4]==0?0:0xFFFFFF);
				
				}
			}
			
		}
		
		}
		
		if(elapsedtime - this.startTime > 10000)
		{
				if(this.blowIndex < this.blows.length)
				{
				var xx = this.blows[this.blowIndex][2];
				var yy = this.blows[this.blowIndex][1];
				var zz = this.blows[this.blowIndex][0];
				while(elapsedtime-this.previousBlow > 80)
				{
				this.textInd = this.text.length-1;
				if(!this.cubeReseted)
				{
					this.cubeReseted = true;
					for(var i = -4; i < 5; i++)
					{
						for(var j = -4; j < 5; j++)
						{
						if(this.cubes[4][i][j] != null)
							this.cubes[4][i][j].material.color = new THREE.Color(this.instructions[this.text.charAt(this.textInd)][4-i][j+4]==0?0:0xFFFFFF);
						if(this.cubes[-4][i][j] != null)
							this.cubes[-4][i][j].material.color = new THREE.Color(this.instructions[this.text.charAt(this.textInd)][4-i][j+4]==0?0:0xFFFFFF);
						if(this.cubes[i][4][j] != null)
							this.cubes[i][4][j].material.color = new THREE.Color(this.instructions[this.text.charAt(this.textInd)][4-i][j+4]==0?0:0xFFFFFF);
						if(this.cubes[i][-4][j] != null)
							this.cubes[i][-4][j].material.color = new THREE.Color(this.instructions[this.text.charAt(this.textInd)][4-i][j+4]==0?0:0xFFFFFF);
						if(this.cubes[i][j][-4] != null)
							this.cubes[i][j][-4].material.color = new THREE.Color(this.instructions[this.text.charAt(this.textInd)][4-i][j+4]==0?0:0xFFFFFF);
						if(this.cubes[i][j][4] != null)
							this.cubes[i][j][4].material.color = new THREE.Color(this.instructions[this.text.charAt(this.textInd)][4-i][j+4]==0?0:0xFFFFFF);
						
						}
					}
				}
				this.previousBlow = elapsedtime;
				if(this.blowIndex < this.blows.length)
				{
				//	var xx = this.blows[this.blowIndex][2];
				//	var yy = this.blows[this.blowIndex][1];
				//	var zz = this.blows[this.blowIndex][0];
					this.blowIndex++;
						
						for(var i = 0; i < this.exp.length; i++)
						{
							var off = this.exp[i];
							var xo = xx+off[0];
							var yo = yy+off[1];
							var zo = zz+off[2];
							if(xo >= -4 && xo <= 4 &&
							   yo >= -4 && yo <= 4 &&
							   zo >= -4 && zo <= 4 &&
							   this.cubes[zo][yo][xo] != null
							   )
							{
							console.log("Remove " + xo + " " + yo + " " +zo);
							this.scene.remove(this.cubes[zo][yo][xo]);
						//	this.fadeout.push(this.cubes[zo][yo][xo])
							this.cubes[zo][yo][xo] = null;
							//this.scene.add(this.particles[zo][yo][xo]);
	//						this.particles[i][j] = new THREE.ParticleSystem(partGeo, material);
								
							}
						}
				//	this.camera.position.x = xx*25;
				//	this.camera.position.y = yy*25;
				//	this.camera.position.z = zz*25;
				//	this.camera.lookAt(new THREE.Vector3(xx,yy,zz));
					//var xx = 4-this.remove%9;
					//var yy = 4-Math.floor(this.remove/(9))%9;
					//var zz = 4-Math.floor(this.remove/(9*9))%9;
					this.remove++;
				}
			}
			
			this.camera.position.x += (xx*35 - this.camera.position.x  )/10;
			this.camera.position.y += (yy*35 - this.camera.position.y)/10;
			this.camera.position.z += (zz*35 - this.camera.position.z )/10;
			
			this.ctx += (xx-this.ctx)/5
			this.cty += (yy-this.cty)/5
			this.ctz += (zz-this.ctz)/5
			
			this.camera.lookAt(new THREE.Vector3(xx,yy,zz));
		}
		}
		for(var i = 0; i < this.fadeout.length; i++)
		{
			var c = this.fadeout[i];
			var col = c.material.color;
			var a = col>>24;
			a-=1;
			col = (col&0xFFFFFF) + (a<<24);
			c.material.color = new THREE.Color(col);
		}
		
		if(this.blowIndex >= this.blows.length)
		{
			for(var k = -4; k <= 4; k++)
			{
				for(var i = -4; i <= 4; i++)
				{
					for(var j = -4; j <= 4; j++)
					{
						
						var cube = this.cubes[k][i][j];
						if(cube)
						{
							cube.position.x += i+i+i;
							cube.position.y += j+j+j;
							cube.position.z += k+k+k;
							cube.rotation.x += i/30;
							cube.rotation.y += j/40;
							cube.rotation.z += k/50;
							
						}
					}
				}
			}
			if(!this.setvis)
			{
				this.setvis = true;
				for(var i = 0; i < this.actualFcubes.length; i++)
				{
					this.actualFcubes[i].visible = true;
				}
			}
		}
		if(elapsedtime - this.startTime > 1000)
			this.count+=td;
	}
	
	/**
	* Main controller calls render function
	* @param renderTarget The rendertarget to render to
	*/
	p.render = function(elapsedtime){
	//	this.main.renderer.render(this.scene, this.camera, this.renderTarget);
		this.composer.render();
	}
	
	/**
	* Post render if required. Postprocessing actions can be done here for example.
	* @param renderTarget The rendertarget for final image. It is different than the one given in render-function.
	*/
	p.postRender = function(elapsedtime){
		
	}
	
	/**
	* Ending is near. Start animating ending if necessary
	* @param next part
	*/
	p.prepareEnd = function(elapsedtime,next){
		
	}

	/**
	* Order to end the part
	*/
	p.endPart = function(elapsedtime){
	
	}
	
}())