sampler2D input : register(s0);
 
float Timer : register(C0);
 
static const float2 poisson[12] =
{
        float2(-0.326212f, -0.40581f),
        float2(-0.840144f, -0.07358f),
        float2(-0.695914f, 0.457137f),
        float2(-0.203345f, 0.620716f),
        float2(0.96234f, -0.194983f),
        float2(0.473434f, -0.480026f),
        float2(0.519456f, 0.767022f),
        float2(0.185461f, -0.893124f),
        float2(0.507431f, 0.064425f),
        float2(0.89642f, 0.412458f),
        float2(-0.32194f, -0.932615f),
        float2(-0.791559f, -0.59771f)
};
 
float4 main(float2 uv : TEXCOORD) : COLOR
{
    float2 Delta = { sin(Timer + uv.x*23 + uv.y*uv.y*17)*0.02 , cos(Timer + uv.y*32 + uv.x*uv.x*13)*0.02 };
 
    float2 NewUV = uv + Delta;
 
    float4 Color = 0;
    for (int i = 0; i < 12; i++)
    {
       float2 Coord = NewUV + (poisson[i] / 50);
       Color += tex2D(input, Coord)/12.0;
     }
     Color += tex2D(input, uv)/4;
     Color.a = 1.0;
     return Color;
}
