/**

 */

wideload.TwisterShader = {

	uniforms: {

		"delta":   { type: "f", value: 0.005 },

	},

	vertexShader: [

		"varying vec3 vNormal;",
		"uniform float delta;",
		"uniform float collapse;",
		"uniform float distance;",
		"void main() {",

			"vNormal = normal;",
			"vec3 p = position;",
			"//float length = length(p-origin);",
			"//p.z += sin(delta+p.y/4.0+position.x * 1.0 + position.z*1.0)*80.0;",
			"//p.x += cos(delta+p.y/5.0)*80.0;",
			"//p.y += cos(delta*(distance+10.0)/50.0)*distance/8.0;",
			
			
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( p, 1.0 );",

		"}"

	].join("\n"),

	fragmentShader: [

		"varying vec3 vNormal;",
		"uniform float rm;",
		"uniform float gm;",
		"uniform float bm;",
		"uniform float distance;",

		"void main() {",
			"vec3 light = vec3(0.0,0.0,0.1);",
			"light = normalize(light);",
			"float dProd = abs(dot(vNormal, light));",
			"gl_FragColor = vec4(dProd, dProd, dProd, 1.0);",

		"}"

	].join("\n")

};
