﻿var Peili = function(duration, startTime, endTime){
  //kantaluokan rakentajan kutsu
  PartBase.call(this, duration, startTime, endTime);
}

Peili.prototype = PartBase.prototype.inheritance();

//scene is initialized before demo starts
Peili.prototype.initScene = function(){
  
  //MAIN SCENE
  this.scene = new THREE.Scene();
  
  var ambient = new THREE.AmbientLight(0xFFFFFF);
  this.scene.add(ambient);
  
  var pointLight = new THREE.PointLight(0xAACCDD);
  pointLight.position.y = 200;
  pointLight.position.z = 200;
  pointLight.position.x = -100;
  this.scene.add(pointLight);
  
  this.camera = new THREE.PerspectiveCamera();
  this.camera = new THREE.PerspectiveCamera();
  this.camera.position.z = 450;
  this.camera.position.y = 400;
  this.camera.rotation.x = -Math.PI/4;
  this.scene.add(this.camera);
  
  this.camera2 = new THREE.PerspectiveCamera();
  this.camera2 = new THREE.PerspectiveCamera();
  this.camera2.rotation.x = Math.PI/2;
  this.camera2.position.y = -350;
  this.scene.add(this.camera2);
  
  this.rtt = new THREE.WebGLRenderTarget(512, 512);
  
  this.createBalls();
  
  var roofMaterial = new THREE.MeshPhongMaterial({
    color : 0x5959AB,//0x5D478B,
    ambient : 0x304132,
    emissive : 0x302B54,//0x1C1C1C,
    specular : 0x302B54,//0x483D8B,
    side : THREE.BackSide
  });
  
  this.roof = new THREE.Mesh(new THREE.SphereGeometry(512, 16, 16), roofMaterial);
  this.scene.add(this.roof);
  
  
  var planeMaterial = new THREE.MeshBasicMaterial({
    map : this.rtt,
    side : THREE.DoubleSide
  });
  
  this.plane = new THREE.Mesh(new THREE.PlaneGeometry(256, 256), planeMaterial);
  this.plane.rotation.x = Math.PI/2;
  this.plane.position.y = -100;
  this.plane.visible = false;
  this.scene.add(this.plane);
  
  this.initialY = this.balls.position.y
  
  this.phase = 1;
  
  this.t1 = 2.88;
  this.s1 = 5-this.initialY;
  this.v1 = this.s1/this.t1;

  
  this.t2 = 3.84;
  this.v2 = -80
  this.a2 = this.v2/this.t2;
  
  this.t4 = 3.84;
  this.v4 = 36;
  this.a4 = this.v4/this.t4;
  
  this.t3 = this.duration-this.t1-this.t2-this.t4;
}

//rendering function
Peili.prototype.render = function(elapsedTime){
  this.plane.visible = false;
  TDEMO.renderer.render(this.scene, this.camera2, this.rtt);
  this.plane.visible = true;
  TDEMO.renderer.render(this.scene, this.camera);
}

Peili.prototype.prepare = function(elapsedTime){
  this.startTime = elapsedTime;
}

//Operations tahta takes place before rendering in every cycle
Peili.prototype.animate = function(elapsedTime){
  
  if(this.phase == 1 && (elapsedTime-this.startTime) >= this.t1){
    this.phase = 2;
  }
  else if(this.phase == 2 && (elapsedTime-this.startTime-this.t1) >= this.t2){
    this.phase = 3;
  }
  else if(this.phase == 3 && (elapsedTime-this.startTime-this.t1-this.t2) >= this.t3){
    this.phase = 4;
    this.initialY = this.balls.position.y;
  }
  
  if(this.phase == 1){
    var t = (elapsedTime-this.startTime);
    this.balls.position.y =
      this.initialY+(this.v1*t);
      
    for(i = 0; i < this.balls.children.length; ++i){
      var ball = this.balls.children[i];
      ball.scale.y = (Math.cos((elapsedTime+i)) + 1.0);
    }
  }
  else if(this.phase == 2){
    this.balls.rotation.y += 0.01;
    
    var t = (elapsedTime-this.startTime-this.t1);
    var v = this.a2*t;
    
    for(i = 0; i < this.balls.children.length; ++i){
      var ball = this.balls.children[i];
      ball.scale.y = (Math.cos((elapsedTime+i)) + 1.0);

      ball.position.y =v*Math.sin(elapsedTime+i);
    }
  }
  else if(this.phase == 3){
    this.balls.rotation.y += 0.01;
    
    for(i = 0; i < this.balls.children.length; ++i){
      var ball = this.balls.children[i];
      ball.scale.y = (Math.cos((elapsedTime+i)) + 1.0);
      ball.position.y = (this.v2*Math.sin((elapsedTime+i)));
    }
  }
  else if(this.phase == 4){
    var t = (elapsedTime-this.startTime-this.t1-this.t2-this.t3);
    var v = this.a4*t;
    
    this.balls.position.y = this.initialY+(v*t);

    this.balls.rotation.y += 0.01;
    for(i = 0; i < this.balls.children.length; ++i){
      var ball = this.balls.children[i];
      ball.scale.y = (Math.cos((elapsedTime+i)) + 1.0);
      ball.position.y = (this.v2*Math.sin((elapsedTime+i)));
    }
  }

}

Peili.prototype.createBalls = function(){

  this.balls = new THREE.Object3D();
  this.scene.add(this.balls);
  
  var ballMaterial = new THREE.MeshPhongMaterial({
    color : 0x483D8B,
    ambient : 0x483D8B,
    emissive : 0x5D478B,
    specular : 0x5D478B
  });
  
  var BALLS_AMOUNT = 6;
  var r = 70;
  var delta = 2*Math.PI/BALLS_AMOUNT;
  var alpha = 0;

  for(var i = 0; i < BALLS_AMOUNT; ++i){
   
    var ball = new THREE.Mesh(new THREE.SphereGeometry(18, 16, 16), ballMaterial);
    
    ball.position.z = Math.sin(alpha)*r;
    ball.position.x = Math.cos(alpha)*r;
    this.balls.add(ball);
    
    alpha += delta;
  }
  this.balls.position.y = 300;
}

