uniform sampler2D tex0;
uniform sampler2D tex1;
uniform sampler2D tex2;

uniform float groupalpha;
uniform float titlealpha;

uniform vec3 colormod;
varying vec2 texturecoordinate;

void main(void)
{
	float f = groupalpha * titlealpha * 0.1 + 0.02;
	vec2 tcoord = texturecoordinate + (texture2D(tex2, texturecoordinate) * f).rg;
	vec4 group_texel = texture2D(tex0, tcoord);
	vec4 title_texel = texture2D(tex1, tcoord);
	
	group_texel *= groupalpha;
	title_texel *= titlealpha;
	
	vec4 finalcolor = group_texel + title_texel;
	finalcolor.r *= colormod.x;
	finalcolor.g *= colormod.y;
	finalcolor.b *= colormod.z;
	gl_FragColor = finalcolor;// * logoalpha * fade;//vec4(normal_texel.rgb, 1);//vec4(normal_texel.rgb, logoalpha);

}