#include <SDL/SDL.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <math.h>
#define PI 3.1412


#define WIDTH 1280
#define HEIGHT 720
#define BPP 32


static GLdouble spin= 0;
static GLdouble distance= 20;
static GLdouble lookatx= 0;
static double pixels= 1;

GLfloat mat_specular[] = { 1.0, 1.0, 1.0, 1.0 };
GLfloat mat_shininess[] = { 100 };
GLfloat mat_amb_diff_red[] = {1.0, 0.2, 0.3, 1.0};
GLfloat mat_amb_diff_white[] = {1.0, 1.0, 1.0, 1.0};
GLfloat mat_emissivity[] = {0.5, 0.0, 0.0, 1.0};
GLfloat mat_no_emissivity[] = {0.0, 0.0, 0.0, 1.0};
GLfloat light_diffuse[] = {1.0, 1.0, 1.0, 1.0};
GLfloat light_specular[] = {1.0, 1.0, 1.0, 1.0};
GLfloat light_position[] = { 10.0, 0.0, 10.0, 1.0 };
GLfloat light_position2[] = { 10.0, 0.0, 10.0, 1.0 };





void drawCube(float width, float height, float depth){
// cube ///////////////////////////////////////////////////////////////////////
//    v6----- v5
//   /|      /|
//  v1------v0|
//  | |     | |
//  | |v7---|-|v4
//  |/      |/
//  v2------v3

    GLfloat vertices[8][3] = {
                                {width, height, 0.0},   //Vertex 0 FUR
                                {0.0, height, 0.0},     //Vertex 1 FUL
                                {0.0, 0.0, 0.0},        //Vertex 2 FDL
                                {width, 0.0, 0.0},      //Vertex 3 FDR
                                {width, 0.0, depth},    //Vertex 4 BDR
                                {width, height, depth}, //Vertex 5 BUR
                                {0.0, height, depth},   //Vertex 6 BUL
                                {0.0, 0.0, depth}       //Vertex 7 BDL
                        };
    int face[6][4] = { {0,1,2,3}, {5,0,3,4}, {0,5,6,1}, {1,6,7,2}, {7,4,3,2}, {4,7,6,5} };

    glBegin(GL_QUADS);
    for(int i=0;i<6;i++){
        if(i!=4 && i!=2)glTexCoord2f(0,0);
            glVertex3fv(vertices[face[i][0]]);
        if(i!=4 && i!=2)glTexCoord2f(1,0);
            glVertex3fv(vertices[face[i][1]]);
        if(i!=4 && i!=2)glTexCoord2f(1,1);
            glVertex3fv(vertices[face[i][2]]);
        if(i!=4 && i!=2)glTexCoord2f(0,1);
            glVertex3fv(vertices[face[i][3]]);
    }
        glEnd();
}

void chim(void)
{
   GLfloat cubesize = 1.0;
   int x[] = {
             0,-1,-1,-1, 0, 0, 1, 1, 1, //c
             2, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, //h
             2, 0, 0, 0, 0, 0, //i
             2, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0 //m
   };
   int y[] = {
             0, 0, 0,-1,-1,-1,-1, 0, 0, //c
             0, 1, 1, 1, 1, 1, 1, 1,-3, 0, 0,-1,-1,-1,-1, //h
             0, 1, 1, 1, 1, 3, //i
            -7, 1, 1, 1, 1, -1, 1, 0,-1,-1,-1,-1, 3, 1, 0, -1,-1,-1,-1 //m
   };
   int totpix = sizeof(x) / sizeof(GLfloat);
   for(int i=0;i<pixels && i<totpix;i++){
        glTranslatef(x[i]*cubesize,y[i]*cubesize,0);
        if(i<pixels-3)
            drawCube(cubesize,cubesize,cubesize);
        else
        {
            glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, mat_amb_diff_white);
            drawCube(cubesize,cubesize,cubesize);
        }
   }
   if(pixels>23)
           lookatx = 9;
}

void reshape(int w, int h)
{
  glViewport(0, 0, (GLsizei) w, (GLsizei) h);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(30, (GLfloat) w / (GLfloat) h, 0.10, 220.0);
  glMatrixMode(GL_MODELVIEW);
}

//void _start() {
int main() {
	SDL_Event e;
	SDL_SetVideoMode(WIDTH, HEIGHT, BPP, SDL_OPENGL); /* | SDL_FULLSCREEN); */
	SDL_WM_SetCaption("gl", 0);
	SDL_ShowCursor(0);
   glClearColor (0.0, 0.0, 0.0, 0.0);
   glShadeModel (GL_SMOOTH);
   glLightfv(GL_LIGHT0, GL_DIFFUSE, light_diffuse);
   glLightfv(GL_LIGHT0, GL_SPECULAR, light_specular);
   glEnable(GL_LIGHTING);
   glEnable(GL_LIGHT0);

	do {
		SDL_PollEvent(&e);

		int t=SDL_GetTicks(); /* timer ms */

		/*
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		glLoadIdentity();

		// scenes
		if(t >= 0 && t <= 2000)
			glClearColor(1, 0, 0, 0);
		if(t >= 2000 && t <= 4000)
			glClearColor(0, 1, 0, 0);
		if(t >= 4000 && t <= 6000)
			glClearColor(0, 0, 1, 0);
		if(t >= 6000)
			break;
		*/
reshape(WIDTH, HEIGHT);
   glClearColor(0.0, 0.0, 0.0, 0.0);
   glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glEnable(GL_DEPTH_TEST);
   glPushMatrix();

   glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, mat_amb_diff_white);
   glMaterialfv(GL_FRONT, GL_EMISSION, mat_no_emissivity);
   glLoadIdentity();
   light_position[0] = distance * sin(spin*2*PI/360);
   light_position[2] = distance * cos(spin*2*PI/360);
   gluLookAt( light_position[0]+lookatx, light_position[1], light_position[2], 0.0+lookatx, 0.0, 0.0, 0.0, 1.0, 0.0);
   glLightfv(GL_LIGHT0, GL_POSITION, light_position);
   glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
   glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess);
   glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, mat_amb_diff_red);
   chim();

   glPopMatrix();


  spin += 2;//5;
  pixels += 0.13;
  if(spin == 360){
    spin -= 360 ;
  }

  distance += spin/20000*2;

 // SDL_Delay(10);
		SDL_GL_SwapBuffers();



		if(t >= 30000)
			break;
	} while(e.type!=SDL_KEYDOWN);

	SDL_Quit();

	/* exit */
//	asm ( \
//	"movl $1,%eax\n" \
//	"xor %ebx,%ebx\n" \
//	"int $128\n" \
//	);
	return 0;
}
