#include <stdio.h>
#include <stdint.h>

#define WMAX 256
#define HMAX 256
#define RL32(arr, ofs) (arr[ofs] + (arr[ofs+1] << 8) + (arr[ofs+2] << 16) + (arr[ofs+3] << 24))

int main(int argc, char **argv) {
    uint8_t header[54], image[HMAX][WMAX];
    int c, x, y, w, h, bpp;
    FILE *f;

    /* read 8-bit images as they are, RGB images as grayscale */
    if (!(f = fopen(argv[1], "rb"))) {
        fprintf(stderr, "failed to open %s\n" , argv[1]);
        return 1;
    }

    fread(header, 54, 1, f);

    w = RL32(header, 18);
    h = RL32(header, 22);
    bpp = header[28] + (header[29] << 8);
    fseek(f, RL32(header, 10), SEEK_SET);

    fprintf(stderr, "%ix%i %i bpp\n", w, h, bpp);

    if (w > WMAX || h > HMAX) {
        fprintf(stderr, "image too large\n");
        return -1;
    }

    for (y = h-1; y >= 0; y--) {
        switch(bpp) {
        case 8:
            fread(image[y], w, 1, f);
            break;
        case 24:
        case 32:
            for (x = 0; x < w; x++) {
                int temp = getc(f) + getc(f) + getc(f);
                if (bpp == 32) getc(f);
                image[y][x] = temp / 3;
            }
            break;
        default:
            fprintf(stderr, "can't handle %i-bit BMPs\n", bpp);
        }

        /* align */
        if (w*(bpp/8) & 3)
            fseek(f, 4 - (w*(bpp/8) & 3), SEEK_CUR);
    }

    fclose(f);

    /* insert code that prints tables to stdout here */
    printf("HEIGHT  equ %i\n", h);

    for (c = 0; c < 12; c++) {
        printf("\tMAC COL%i\n", c);
        printf("Col%i\n", c);

        /* store upside-down */
        for (y = h-1; y >= 0; y--) {
            uint8_t byte = 0;

            printf("\t.byte %%");

            for (x = 0; x < 8; x++)
                printf("%i", image[y][x+c*8] > 128);

            printf("\n");
        }

        printf("\tENDM\n");
    }

    return 0;
}
