I=(S=Uno.Content.MeshGenerator = function(){
}).prototype;

S.CreateSphere = function(pivot, radius, slices, stacks)
{
    var horizontalVertexCount = slices + 1;
    var verticalVertexCount = stacks + 1;
    var bodyVertexCount = horizontalVertexCount * verticalVertexCount;
    var bodyIndexCount = (slices * stacks) * 6;
    var vertexCount = bodyVertexCount;
    var indexCount = bodyIndexCount;
    var mesh = Uno.Content.Mesh.$0();
    mesh.Vertices = _newFilledArray(vertexCount, function() { return new Uno.Float3; });
    mesh.Normals = _newFilledArray(vertexCount, function() { return new Uno.Float3; });
    mesh.TexCoords = _newFilledArray(vertexCount, function() { return new Uno.Float3; });
    mesh.Indices = _newFilledArray(indexCount, function() { return 0; });

    for (var j = 0; j < verticalVertexCount; j++)
    {
        for (var i = 0; i < horizontalVertexCount; ++i)
        {
            var k = i + (j * horizontalVertexCount);
            var u = i / slices;
            var v = j / stacks;
            mesh.TexCoords[k] = Uno.Float3.$1(u, 1.0 - v, 0.0);
            u = u * 6.283185;
            v = (v * 3.141593) - 1.570796;
            mesh.Vertices[k] = Uno.Float3.operator_Add(pivot, Uno.Float3.$1((Math.cos(v) * Math.cos(u)) * radius, (Math.cos(v) * Math.sin(u)) * radius, Math.sin(v) * radius));
            mesh.Normals[k] = Uno.Float3.$1(Math.cos(v) * Math.cos(u), Math.cos(v) * Math.sin(u), Math.sin(v));
        }
    }

    for (var i = 0; i < slices; ++i)
    {
        for (var j = 0; j < stacks; ++j)
        {
            var k = (i + (j * slices)) * 6;
            mesh.Indices[k + 0] = (i + (j * horizontalVertexCount)) + 0;
            mesh.Indices[k + 1] = (i + (j * horizontalVertexCount)) + 1;
            mesh.Indices[k + 2] = (i + ((j + 1) * horizontalVertexCount)) + 0;
            mesh.Indices[k + 3] = (i + (j * horizontalVertexCount)) + 1;
            mesh.Indices[k + 4] = (i + ((j + 1) * horizontalVertexCount)) + 1;
            mesh.Indices[k + 5] = (i + ((j + 1) * horizontalVertexCount)) + 0;
        }
    }

    return mesh;
};
