var Fighter;
var Enemy;
var StorageWorks = false;
var Food = new Array();
var inFight = false;


function LoadGame()
{
	//Kan vi spara data p den hr skitdatorn?
	if(typeof(Storage)!=="undefined")
	{
		StorageWorks = true; //S vi vet att vi hmtat data
		
		//Ladda spel
		if(localStorage.Fighter !== null)
		{
			Fighter = localStorage.Fighter.split(':');
		}
	}
	else
	{
		alert("Local storage funkar inte! Ni kommer inte ha ngon mjlighet till att teruppta ert spel!");
	}
	
	//Se till att stta lite standardvrden
	if(Fighter == null)
	{
		Fighter = new Array();
		ResetStats();
	}

	
	//Matlistan
	Food[0] = "chicken";
	Food[1] = "egg";
	Food[2] = "hamburger";
	Food[3] = "kebab";
	Food[4] = "meat";
	Food[5] = "rice";
	Food[6] = "sup";
	Food[7] = "sushi";
	Food[8] = "bread";
	Food[9] = "cheese";
	Food[10] = "potato";
	Food[11] = "salmon";
	
	UpdateFighterInfo();
}

function ResetStats()
{

	//Defaultvrden
	Fighter[0] = "Hsten";	// Namn
	Fighter[1] = "1";		// Level
	Fighter[2] = "5";		// Defense  
	Fighter[3] = "11";		// Extra attack power
	Fighter[4] = "0";		// Experience
	Fighter[5] = "1000";	// Health

	UpdateFighter(1, 0)
	SaveGame();
	window.location.reload();
}


function SaveGame()
{
	//Eftersom det inte gr spara annat n strngar i localstorage, s fr jag sammla ihop allt.
	if(StorageWorks)
	{
		var StringSum = "";

		for(i = 0; i < Fighter.length; i++)
		{
			StringSum = StringSum + Fighter[i] + ":";
		}
		
		StringSum = StringSum.slice(0,StringSum.length-1);
		localStorage.Fighter = StringSum;
	}
	else
	{
		return alert('Sparade inte ngon data efter matchen! Bhhh');
	}
}


/* -------------------------------------------------------------------------- */
/*   Fiendespecifika vrden!                                                 */


function GenerateEnemy()
{

	if(!inFight)
	{
		inFight = true;
	}
	else
	{
		return '';
	}
	
	Enemy = new Array();
	
	//Defaultvrden
	Enemy[0] = RandomFood();	// Allergi
	Enemy[1] = GenerateEnemyLevel();	// Level
	Enemy[2] = 5 + (parseInt(Enemy[1])*2);	// Defense  
	Enemy[3] = 10 + (parseInt(Enemy[1])*2);		// Extra attack power
	Enemy[4] = Enemy[0]; 		// Mat som den tl
	
	//Stll in s att fiende tl samma mat som den r svag fr
	while(Enemy[4] == Enemy[0])
	{	
		Enemy[4] = RandomFood();
	}
	
	Enemy[5] = Enemy[1] * 600; // Health
	
	var enemy = EnemyPicture(Enemy[1]);
	document.getElementById('EnemyImage').src = ("images/character/chainkiller0" + enemy + ".apng"); // Grafisk fiende
	
	//TODO: Namn p fiende (rd, bl etc...)
	
	SetText('VersusText', 'VS');
	UpdateEnemyInfo();

}


function EnemyPicture(Level)
{
	return Math.floor(Math.random()*7);
}


// Hmta random mat ifrn matlistan
function RandomFood()
{
	var ReturnValue;
	
	ReturnValue = Food[Math.floor(Math.random()*12)];
	return ReturnValue;
}

/* Mina hemliga algorithmer fr att generera level t fienden.
	Jag erknner, jag har ingen aning om hur den fungerar...
*/
function GenerateEnemyLevel()
{
	var FighterLevel = Fighter[1];
	var MaxLevel;
	var MinLevel;
	var ReturnValue = 1;
	
	if(FighterLevel == ReturnValue)
	{return ReturnValue; }
	
	if(FighterLevel > 11)
	{
		FighterLevel + Math.floor(Math.random()*5)
	}
	else
	{
		MaxLevel = FighterLevel;
	}
	
	if(FighterLevel > 7)
	{
		MinLevel = FighterLevel - Math.floor(Math.random()*4);
	}
	else
	{
		MinLevel = 1;
	}
	
	var OrgieMedNaknaManniskor = Math.floor(Math.random()*100);

	
	if(OrgieMedNaknaManniskor > (Math.floor(Math.random()*10) + 63))
	{
		ReturnValue = MaxLevel;
	}
	else
	{
		ReturnValue = Math.floor(Math.random()*FighterLevel)
	}

	return ReturnValue;
}


/* Fightervrden
*/
function UpdateFighter(Level, exp)
{
	Fighter[0] = "Greger";	// Allergi
	Fighter[1] = Level;	// Level
	Fighter[2] = 7 + (Level*2);	// Defense  
	Fighter[3] = 9 + (Level*2);		// Extra attack power
	Fighter[4] = exp; 		// Mat som den tl
	Fighter[5] = Level * 10; // Health
	
	UpdateFighterInfo();
	SaveGame();
}
/* Attackvrden!
--------------------------------------------------------------------------                                                          
*/


function Attack(DeliciousFood)
{
	if(!inFight)
	{
		return "";
	}
	
	//Visa hur arg jag r
	document.getElementById('FighterImage').src = "images/character/mainchar_v2_attack.png";
	setTimeout(function(){document.getElementById('FighterImage').src = "images/character/mainchar_v2.png";}, 800)

	SetText('VersusText', '');
	GenerateEnemy();

	
	if(HitEnemy(DeliciousFood) < 1)
	{
		EnemyDies();
	}
	
	if(HitFighter(DeliciousFood) < 1)
	{
		document.getElementById('Loose').style.visibility = 'visible';
	}
	
	UpdateFighterInfo();
	UpdateEnemyInfo();
}

/* Sl monstret */
function HitEnemy(DeliciousFood)
{
	//Attackpwr = Attack - defens
	var FighterBonusAttack =  Fighter[3] - Enemy[2];
	
	//Svaghet
	if(DeliciousFood == Enemy[0])
	{
		FighterBonusAttack = FighterBonusAttack*(Math.floor(Math.random()*FighterBonusAttack)) + FoodAttack(DeliciousFood);
	}

	//Styrka
	if(DeliciousFood == Enemy[4])
	{
		FighterBonusAttack = FighterBonusAttack - (Math.floor(Math.random()*FighterBonusAttack) - 3);
	}

	var v = (FighterBonusAttack * 10);
	Enemy[5] = Enemy[5] - v;
	SetText('FighterHit', 'Fiende tog ' + v + 'hp');
	
	//alert('Attack: ' + FighterBonusAttack +  ' Skada: ' + v + ' Fiendens liv: ' +  Enemy[5])
	
	return Enemy[5];
}

/* Monstret slr */
function HitFighter(DeliciousFood)
{
	//Attackpwr = Attack - defens
	var EnemyBonusAttack = Enemy[3] - Fighter[2];

	if(Enemy[4] == RandomFood)
	{
		EnemyBonusAttack = EnemyBonusAttack*(Math.floor(Math.random()*EnemyBonusAttack));
	}
	
	var v = (EnemyBonusAttack * (Math.floor(Math.random()*13)));
	Fighter[5] = Fighter[5] - v;
	SetText('EnemyHit', 'Du tog ' + v + 'hp');
	
	//alert('Attack: ' + EnemyBonusAttack +  ' Skada: ' + v + ' Ditt liv: ' +  Fighter[5])
	
	return Fighter[5];
	

}

function FoodAttack(DeliciousFood)
{
	var v;
	
	switch(DeliciousFood)
	{
		case 'chicken':
			v =  1;
			break;
		case 'egg':
			v =  2;
			break;
		case 'hamburger':
			v =  3;
			break;
		case 'kebab':
			v =  4;
			break;
		case 'meat':
			v =  5;
			break;
		case 'rice':
			v =  6;
			break;
		case 'sup':
			v =  7;
			break;
		case 'sushi':
			v =  8;
			break;
		case 'bread':
			v =  9;
			break;
		case 'cheese':
			v =  15;
			break;
		case 'potato':
			v =  30;
			break;			
		case 'salmon':
			v =  50;
			break;
		default:
			v =  0;
			break;			
	}
	
	return v;
}


function EnemyDies()
{
	Fighter[4] = parseInt(Fighter[4]) + (150 * parseInt(Enemy[1]));
	Enemy = null;
		
	SetText('EnemyLevel', '');
	SetText('EnemyHealth', '');
	SetText('EnemyBadFood', '');
	SetText('EnemyHit', '');
	SetText('FighterHit', '');
	
	document.getElementById('Win').style.visibility = 'visible';
	document.getElementById('EnemyImage').src = "images/chainsaw.apng";
	inFight = false;
	
	var Level = parseInt(Fighter[1]);
	
	if(Fighter[4] >= Level * 1000)
	{
		Fighter[1] = Level +1;
		Fighter[4] = Fighter[4] - ((Level + 1) * 1000);	
	}
	
	//alert('Level ' + Fighter[1] + ' exp ' + Fighter[4]);
	
	UpdateFighter(Fighter[1], Fighter[4])
}







/* Lite animationer
--------------------------------------------------------------------------              
*/

function MouseOver(ElementID)
{
	document.getElementById(ElementID).style.width = 60;
	document.getElementById(ElementID).style.height = 60;
}

function MouseOut(ElementID)
{
	document.getElementById(ElementID).style.width = 62;
	document.getElementById(ElementID).style.height = 62;
}

function UpdateFighterInfo()
{
	SetText('FighterLevel', 'Level: ' + Fighter[1]);
	SetText('FighterHealth', 'Health: ' + Fighter[5]);
	SetText('FighterExperience', 'Experience: ' + Fighter[4]);
}

function UpdateEnemyInfo()
{
	SetText('EnemyLevel', 'Level: ' + Enemy[1]);
	SetText('EnemyHealth', 'Health: ' + Enemy[5]);
	SetText('EnemyBadFood', 'Tl inte: ' + Enemy[0]);
}

function SetText(ElementID, text)
{
	document.getElementById(ElementID).innerHTML = text;
}

function EnableAbilities()
{
	document.getElementById('chicken').src = "images/food/chicken.png";
	document.getElementById('egg').src = "images/food/egg.png";
	document.getElementById('hamburger').src = "images/food/hamburger.png";
	document.getElementById('kebab').src = "images/food/kebab.png";
	document.getElementById('meat').src = "images/food/meat.png";
	document.getElementById('rice').src = "images/food/rice.png";
	document.getElementById('sup').src = "images/food/sup.png";
	document.getElementById('sushi').src = "images/food/sushi.png";
	document.getElementById('bread').src = "images/food/bread.png";
	document.getElementById('cheese').src = "images/food/cheese.png";
	document.getElementById('potato').src = "images/food/potato.png";
	document.getElementById('salmon').src = "images/food/salmon.png";
}

function DisableAbilities()
{
	document.getElementById('chicken').src = "images/food_bw/chicken.png";
	document.getElementById('egg').src = "images/food_bw/egg.png";
	document.getElementById('hamburger').src = "images/food_bw/hamburger.png";
	document.getElementById('kebab').src = "images/food_bw/kebab.png";
	document.getElementById('meat').src = "images/food_bw/meat.png";
	document.getElementById('rice').src = "images/food_bw/rice.png";
	document.getElementById('sup').src = "images/food_bw/sup.png";
	document.getElementById('sushi').src = "images/food_bw/sushi.png";
	document.getElementById('bread').src = "images/food_bw/bread.png";
	document.getElementById('cheese').src = "images/food_bw/cheese.png";
	document.getElementById('potato').src = "images/food_bw/potato.png";
	document.getElementById('salmon').src = "images/food_bw/salmon.png";
}












