// mog
/*jslint devel: true, browser: true */
var Zoom = (function () {

    "use strict";

    var _model,
        _duration = 0,
        _width,
        _height,
        _holder,
        _canvas,
        _ctx;

    function init(duration, model) {

        console.log("CHANGE_ME - init()");

        _duration = duration;
        _model = model;
        _width = _model.width();
        _height = _model.height();

        _holder = document.createElement('div');
        _canvas = document.createElement('canvas');
        _ctx = _canvas.getContext('2d');
        _canvas.width = _width;
        _canvas.height = _height;

        _canvas.style.cssText = 'position:absolute;';
        _holder.appendChild(_canvas);

        _model.stage.appendChild(_holder);

        _model.addEventListener('model:resize', resize);
        //--
    }

    var startTime;
    function render(sceneTime, floatBeat, frameDelta) {

        var zoomDuration = 2000;

        if(startTime == undefined)
            startTime = sceneTime;

        var offset = 100 - (100 / zoomDuration * (sceneTime - startTime));

        if((offset < 0) || (offset > 100))
            offset = 0;

        _ctx.drawImage(Meat.zoom, -offset / 2, -offset / 2, _width + offset, _height + offset);
        _ctx.drawImage(Meat.zoomFrame, 0, 0, _width, _height);
    }

    function onBeat(integerBeat, msTime, majorBeat, minorBeat) {

        if (integerBeat % 8 === 0) {

        }
    }

    function clear() {
        _model.removeEventListener('model:resize', resize);
        _model.stage.removeChild(_holder);
    }

    function resize(event) {

        _width = event.info.width;
        _height = event.info.height;
    }

    return {
        init  :init,
        render:render,
        onBeat:onBeat,
        clear :clear,
        resize:resize
    };
}());