// mog
/*jslint devel: true, browser: true */
var Wait = (function () {

    "use strict";

    var _model,
        _duration = 0,
        _width,
        _height,
        _holder,
        _canvas,
        _ctx,
        _benzin,
        _earLeft,
        _earRight;

    function init(duration, model) {

        console.log("Wait - init()");

        _duration = duration;
        _model = model;
        _width = _model.width();
        _height = _model.height();

        _holder = document.createElement('div');
        _canvas = document.createElement('canvas');
        _ctx = _canvas.getContext('2d');
        _canvas.width = _width;
        _canvas.height = _height;

        _canvas.style.cssText = 'position:absolute;';
        _holder.appendChild(_canvas);

        _model.stage.appendChild(_holder);

        _model.addEventListener('model:resize', resize);
        //--
        _benzin = new Verlet();

        _benzin.setContext(_ctx);

        var dummy = document.createElement('div');
        dummy.width = 1;

        _benzin.setDiv(dummy);

        _benzin.init({color:'#1e1612',
            rows           :12,
            stickLength    :Math.round(15 / 1080 * _height),
            startX         :190,
            startY         :290,
            endX           :160,
            endY           :337,
            thickness      :Math.round(16 / 1080 * _height)});

        //--headphones
        _earLeft = new Verlet();

        _earLeft.setContext(_ctx);
        _earLeft.setDiv(dummy);

        _earLeft.init({color:'#ece9d6',
            rows           :24,
            stickLength    :Math.round(13 / 1080 * _height),
            startX         :611,
            startY         :295,
            endX           :632,
            endY           :364,
            thickness      :Math.round(4 / 1080 * _height)});

        _earRight = new Verlet();

        _earRight.setContext(_ctx);
        _earRight.setDiv(dummy);

        _earRight.init({color:'#ece9d6',
            rows           :24,
            stickLength    :Math.round(15 / 1080 * _height),
            startX         :632,
            startY         :364,
            endX           :660,
            endY           :295,
            thickness      :Math.round(4 / 1080 * _height)});
            
     var overlay = document.createElement('div');

        if(Demo.isOutlineVersion)
        	overlay.style.backgroundImage = "url(" + Meat.over2His.src +")";
        else
        	overlay.style.backgroundImage = "url(" + Meat.over2Her.src +")";
        
        overlay.setAttribute('class', 'overlay');
        		
        overlay.style.width = _width +'px';
        overlay.style.height = _height +'px';	
        _holder.appendChild(overlay);
    }

    function render(sceneTime, floatBeat, frameDelta) {
        _ctx.drawImage(Meat.wait, 0, 0, _width, _height);

        _ctx.drawImage(Meat.carTankstelle, 0, Math.sin(sceneTime / 100) * 5, _width, _height);
        _ctx.drawImage(Meat['tankstelleHim' + (_minorBeat % 2)], 0, 0, _width, _height);
        _benzin.setEnd(210, 337 + Math.sin(sceneTime / 100) * 5);
        _benzin.render();

        _ctx.drawImage(Meat.stationHerBody, 0, Math.sin(sceneTime / 100) * 4, _width, _height);
        _ctx.drawImage(Meat.stationHerHead, 0, Math.cos(sceneTime / 100) * 4, _width, _height);
        _earLeft.setEnd(632, 364 + Math.sin(sceneTime / 100) * 4);
        _earLeft.render();
        _earRight.setEnd(660, 295 + Math.cos(sceneTime / 100) * 4);
        _earRight.render();
    }

    var _minorBeat = 0;

    function onBeat(integerBeat, msTime, majorBeat, minorBeat) {

        _minorBeat = minorBeat;
        if (integerBeat % 8 === 0) {

        }
    }

    function clear() {
        _model.removeEventListener('model:resize', resize);
        _model.stage.removeChild(_holder);
    }

    function resize(event) {

        _width = event.info.width;
        _height = event.info.height;
    }

    return {
        init  :init,
        render:render,
        onBeat:onBeat,
        clear :clear,
        resize:resize
    };
}());