// mog
/*jslint devel: true, browser: true */
var RealIntro = (function () {

    "use strict";

    var _model,
        _duration = 0,
        _width,
        _height,
        _holder,
        _canvas,
        _ctx,
        SPRITE_WIDTH = 64,
        SPRITE_HEIGHT = 64,
        SPRITE_FRAMES = 6 - 1,
        AMOUNT = 10,
        KEEP_ALIVE = 1,
        _p = [],
        _minorBeat,
        _majorBeat;

    function init(duration, model) {

        console.log("RealIntro - init()");

        _duration = duration;
        _model = model;
        _width = _model.width();
        _height = _model.height();

        _holder = document.createElement('div');
        _canvas = document.createElement('canvas');
        _ctx = _canvas.getContext('2d');
        _canvas.width = _width;
        _canvas.height = _height;

        _canvas.style.cssText = 'position:absolute;';
        _holder.appendChild(_canvas);

        _model.stage.appendChild(_holder);

        _model.addEventListener('model:resize', resize);
        //--
    }

    var _startTime,
        _lastFrame,
        _blinked = [false, false, false];

    function render(sceneTime, floatBeat, frameDelta) {

        var blendInDuration = 5000,
            twinkleDuration = 750,
            frame;

        _ctx.fillStyle = '#296d92';//skyblue
        _ctx.fillRect(0, 0, _width, _height);

        _ctx.fillStyle = 'rgba(30,22,18,' + (1 - (1 / blendInDuration * sceneTime)) + ')'; //black
        _ctx.fillRect(0, 0, _width, _height);

        if ((_majorBeat == 1 && _minorBeat >= 1) && (_blinked[0] === false)) {

            KEEP_ALIVE = 0;

            if (_startTime == undefined) {
                AMOUNT = 1;
                _p = [];
                createParticles();
                _startTime = sceneTime;
            }

            frame = Math.round(5 / twinkleDuration * (sceneTime - _startTime));

            if (frame <= 5) {

                if (_lastFrame != frame) {
                    _lastFrame = frame;
                    animateStars();
                } else {
                    animateStars(false);
                }
            } else {
                _blinked[0] = true;
                _lastFrame = undefined;
                _startTime = undefined;
            }
        }

        //--
        if ((_majorBeat == 3 && _minorBeat >= 1) && (_blinked[1] === false)) {

            KEEP_ALIVE = 0;

            if (_startTime == undefined) {
                AMOUNT = 2;
                _p = [];
                createParticles();
                _startTime = sceneTime;
            }

            frame = Math.round(5 / twinkleDuration * (sceneTime - _startTime));

            if (frame <= 5) {

                if (_lastFrame != frame) {
                    _lastFrame = frame;
                    animateStars();
                } else {
                    animateStars(false);
                }
            } else {
                _blinked[1] = true;
                _lastFrame = undefined;
                _startTime = undefined;
            }
        }

        if ((_majorBeat == 5 && _minorBeat >= 1) && (_blinked[2] === false)) {

            KEEP_ALIVE = 0;

            if (_startTime == undefined) {

                AMOUNT = 3;
                _p = [];
                createParticles();
                _startTime = sceneTime;
            }

            frame = Math.round(5 / twinkleDuration * (sceneTime - _startTime));

            if (frame <= 5) {

                if (_lastFrame != frame) {
                    _lastFrame = frame;
                    animateStars();
                } else {
                    animateStars(false);
                }
            } else {
                _blinked[2] = true;
                _lastFrame = undefined;
                _startTime = undefined;
            }
        }
    }

    function onBeat(integerBeat, msTime, majorBeat, minorBeat) {

        _majorBeat = majorBeat;
        _minorBeat = minorBeat;
    }

    function createParticles() {

        for (var i = 0; i < AMOUNT; i++) {

            _p.push({
                "i"   :(KEEP_ALIVE ? Math.floor(Random.float() * SPRITE_FRAMES) : 1),
                "dir" :1,
                "life":0,
                "x"   :Math.round(Random.float() * _width - 60) + 30,
                "y"   :Math.round(Random.float() * _height - 60) + 30
            });
        }
    }

    function animateStars(updateParticle) {

        for (var i = 0; i < _p.length; i++) {

            if (updateParticle !== false) {

                if ((_p[i].i >= SPRITE_FRAMES) || (_p[i].i == 0)) {
                    _p[i].dir *= -1;
                    _p[i].life++;

                    if ((_p[i].life >= 2) && KEEP_ALIVE) {

                        _p[i].x = Math.round(Random.float() * _width - 60) + 30;
                        _p[i].y = Math.round(Random.float() * _height - 60) + 30;
                        _p[i].life = 0;
                    }
                }

                _p[i].i += _p[i].dir;
            }

            drawStar(_p[i].x, _p[i].y, _p[i].i);
        }
    }

    function drawStar(x, y, index) {

        _ctx.drawImage(Meat.star, index *
            SPRITE_WIDTH, 0, SPRITE_WIDTH, SPRITE_HEIGHT, x, y, SPRITE_WIDTH, SPRITE_HEIGHT);
    }

    function clear() {
        _model.removeEventListener('model:resize', resize);
        _model.stage.removeChild(_holder);
    }

    function resize(event) {

        _width = event.info.width;
        _height = event.info.height;
    }

    return {
        init  :init,
        render:render,
        onBeat:onBeat,
        clear :clear,
        resize:resize
    };
}());