// mog
/*jslint devel: true, browser: true */
var Demo = (function () {
    "use strict";
/*
    "a modern tale of love and passion in the brutal world of demoscene -Den";

*/
    var _audio,
        _sceneList,
        _model,
        BPM = 180.14706,
        BEAT_OFFSET = 454,
        AUDIO_URL = 'data/den_-_infravaganza_galore_-_chip_8_channels_9_BigBen_-_Final.ogg',
        AUDIO_VOLUME = 1,
        AUDIO_STARTPOSITION = 0;

    function setModel() {

        _model = new Model();
        _model.stage = document.getElementById('root');
        _model.scale(false);

        _model.width(1280);
        _model.height(720);
        _model.BPM = BPM;
        _model.volume = AUDIO_VOLUME;
    }

    function getAudio() {
        return _audio;
    }

    function getSceneList() {
        return _sceneList.getList();
    }

    function getModel() {
        return _model;
    }

    function getSceneListClass() {
        return _sceneList;
    }

    function loop() {

        var position = _audio.position();
        position = isNaN(position) ? 0 : position;

        if (position < _audio.duration()) {

            if (!_audio.isPaused()) {
                window.requestAnimationFrame(loop, document);
            }

            _sceneList.update(position);
        }
    }

    function onAudioReady() {

        //nuke callback
        _audio.onPlay(null);

        _audio.position(AUDIO_STARTPOSITION);

        _audio.volume(AUDIO_VOLUME);

        console.log(_audio.duration());

        loop();
    }

    function initScenes() {

        setModel();

        _sceneList = SceneList(_model);
        _sceneList.setBPM(BPM);
        _sceneList.setBeatOffsetMs(BEAT_OFFSET);
        _sceneList.add(RealIntro, 0, 5960);
        _sceneList.add(Intro, 5360, 48000);
        _sceneList.add(Zoom, 48000, 53100);
        _sceneList.add(Chat, 53100, 100000);
        _sceneList.add(Wait, 100000, 112000);
        _sceneList.add(Drive, 112000, 133000);
        _sceneList.add(Arrival, 133000, 150000);
        _sceneList.add(Credits, 150000, 218488);

        //218488
    }

    function initAudio() {

        _audio = new Audio();
        _audio.create(AUDIO_URL);
        _audio.onPlay(onAudioReady);
    }

    function start() {

        initAudio();

        initScenes();

        _audio.play();
    }

    return {
        start          :start,
        audio          :getAudio,
        sceneList      :getSceneList,
        model          :getModel,
        sceneController:getSceneListClass,
        isOutlineVersion:false
    };
}());