uniform sampler2D tex;
uniform float t;
uniform float t_scene;
uniform vec2 screen;
uniform vec4 ipos;

#ifdef vertexcompile

smooth out vec2 coord;

layout (location=0) in vec2 pos;

void main()
{
	//float scaling = 1.0f + 0.1*sin(t);
	float scaling = 1.0;
	
	float zoom = sqrt(max(0.0, t_scene-9.5) * 0.05);
	scaling += zoom;
	
	coord = pos;
	//coord *= 1.0;
	
	vec4 fpos = ipos;
	fpos.zw *= scaling;
	fpos.yw = -fpos.yw;
	fpos.y += zoom*0.2;
	fpos.x -= zoom*0.4;

	gl_Position = vec4(pos*fpos.zw+fpos.xy*2.0-vec2(1.0,-1.0), .0, 1.0);
}
#endif

#ifdef fragmentcompile

smooth in vec2 coord;

layout (location=0) out vec4 outcol;

void main()
{
	vec4 col = texture2D(tex, coord);
	
	float fadein = min(1.0, t_scene/5.0 - 0.5); 
	float alpha = fadein;
	float timemult = 12.0;
	float blink = (t_scene*timemult - floor(t_scene*timemult)) ;
	alpha *= mix(1.0, blink, 0.3);
	outcol = col;
	outcol.a *= alpha;
	
}
#endif
