uniform float t;
uniform float beats;
uniform float bounce;
uniform float kick;
uniform float saw;

uniform float syncdistort;

uniform mat4 matrix;

vec3 hsv(float h,float s,float v) {
	return mix(vec3(1.),clamp((abs(fract(h+vec3(3.,2.,1.)/3.)*6.-3.)-1.),0.,1.),s)*v;
}

float rand(vec2 coordinate) {
    return fract(sin(dot(coordinate.xy, vec2(12.9898, 78.233))) * 43758.5453);
}

#ifdef vertexcompile

layout (location=0) in vec3 pos;
layout (location=1) in vec3 nor;
layout (location=3) in vec3 color;
smooth out vec3 ppos, pnor, pcol;

void rZ(inout vec3 p, float a) {
	float c,s;vec3 q=p;
	c = cos(a); s = sin(a);
	p.x = c * q.x - s * q.y;
	p.y = s * q.x + c * q.y;
}

void main()
{
	//float syncdistort = 1.0;
	vec3 newpos = pos;
	//newpos.z += t*5.0;
	newpos.x += t + sin(newpos.y*newpos.y);
	//newpos.z = mod(newpos.z , 400.0);
	newpos.z = newpos.z * 20.0;
	//rZ(newpos, pos.x * (0.03));
	
	float shade = 5.0/(length(newpos.xy)+0.1);
	shade += (0.5-rand(pos.xz)) * shade;
	//pcol = vec3(shade, shade, shade*0.8);
	pcol = hsv(
		shade/10.0, 
		min(sqrt(shade*0.4), 0.6), 
		shade);
	ppos = newpos;
	gl_Position = matrix*vec4(newpos, 1.0);
}

#endif

#ifdef fragmentcompile

smooth in vec3 pnor, ppos, pcol;
layout (location=0) out vec4 outcol;

uniform sampler2D tex, moss;

void main()
{
	//float l = dot(normalize(pnor),normalize(vec3(1.0,1.0,.5)))*.5+.5;
	//vec4 ys = l*pnor.y*texture2D(tex, ppos.xz*.1);
	//if(pnor.y<.0)
	//	ys = -l*pnor.y*texture2D(moss, ppos.xz*.1);
	//outcol = l*abs(pnor.x)*texture2D(tex, ppos.yz*.1)+ys+l*abs(pnor.z)*texture2D(tex, ppos.xy*.1)+vec4(vec3(.0),1.0);
	vec3 c = pcol;
	float alpha = 1.0;
	outcol = vec4(c, alpha);
}
#endif
