
uniform sampler2D tex;
uniform float t;
uniform float t_scene;
uniform vec2 screen;
uniform vec4 ipos;

uniform float fadeout;

#ifdef vertexcompile

smooth out vec2 coord;
layout (location=0) in vec2 pos;

void main()
{
	coord = pos;
	vec4 fpos = ipos;
	//fpos.zw *= 1.5;
	fpos.yw = -fpos.yw;
	gl_Position = vec4(pos*fpos.zw+fpos.xy*2.0-vec2(1.0,-1.0), .0, 1.0);
}
#endif

#ifdef fragmentcompile

smooth in vec2 coord;
layout (location=0) out vec4 outcol;

void main()
{
	vec4 col = texture2D(tex, coord);
	col.rgb *= min(vec3(0.2), col.rrr);
	outcol = col;
	outcol.a *= 0.2;
	outcol.a -= fadeout*1.5;

}
#endif
