uniform sampler2D tex;
uniform float t;
uniform float t_scene;
uniform vec2 screen;
uniform vec4 ipos;
uniform float t_add;
uniform float saw;
uniform float fadeout; // only in fuckings part

#define PI 3.1415926536

#ifdef vertexcompile

smooth out vec2 coord;
layout (location=0) in vec2 pos;

void main()
{
	//float scaling = 1.0f + 0.1*sin(t);
	float scaling = 1.0;
	
	//float zoom = sqrt(max(0.0, t_scene-10.5) * 0.05);
	float zoom = saw * -0.1 + sin((t_scene + t_add * 0.05) * 2.0 * PI) * 0.1 ;
	if (t_add == 0.0) {
		zoom += 0.15; // embiggen the background
	}
	scaling += zoom;
	
	
	coord = pos;
	//coord *= 1.0;
	
	vec4 fpos = ipos;
	fpos.zw *= scaling;
	fpos.yw = -fpos.yw;
	fpos.y += zoom*0.32;
	fpos.x -= zoom*0.32;
	gl_Position = vec4(pos*fpos.zw+fpos.xy*2.0-vec2(1.0,-1.0), .0, 1.0);
}
#endif

#ifdef fragmentcompile

smooth in vec2 coord;
layout (location=0) out vec4 outcol;

void main()
{
	vec4 col = texture2D(tex, coord);
	
	float fadein = min(1.0, t_scene/5.0 - 0.5); 
	float alpha = fadein;
	float timemult = 12.0;
	float blink = (t_scene*timemult - floor(t_scene*timemult)) ;
	if (t_add == 2.0) {
		float add = saw * 0.2 * col.r;
		col.rgb += vec3(add);
		
		vec4 glow = vec4(0.0, 0.0, 0.0, 0.0);
		int samples = 10;
		float e = 0.003;
		float glowoffset = sin(t_scene * 1.0  * PI) * 0.005;

		for (int i=0;i<samples;i++) {
			vec4 sampl = texture2D(tex, coord + vec2(e * float(i) * 1.0 + glowoffset - e * float(i) * 0.5, e * float(i) * 0.2));
			glow += sampl;
		}
		
		glow.rgb *= 1.0/float(samples);
		glow.rgb *= 2.0;
		//glow.a = length(glow.rgb * 0.5);
		col.rgba += glow.rgba * saw * max(0.0, sin((gl_FragCoord.x/screen.x) * 20.0 - t_scene * 10.0));
	}
	
	
	//alpha *= mix(1.0, blink, 0.3);
	alpha = 1.0 - max(0.0, 1.5*(t_scene - 11.0 + 1.0 * length(col.rgb)));
	alpha = max(0.0, alpha);

	
	outcol = col;
	outcol.a *= alpha;
	
}
#endif
