# $Id: Vocals.pm,v 1.5 2012/03/04 07:58:59 je Exp $

package Track::Vocals;

use Fuzz;
use Moose;

extends qw(Track);

override to_ly => fn {
  my ($self, $modes) = @_;
  my $pick_by_tracktype = fn { $self->simultence
                                    ->track($self->trackname, $_[0])
                                    ->to_ly($modes) };
  (
    [ qw(\new Voice =), qq{"${\ $self->trackname }"}, '{',
        [ $pick_by_tracktype->('Voice') ],
      '}' ],
    [ qw(\new Lyrics = "lyrics" \lyricsto), qq{"${\ $self->trackname }"}, '{',
        [ $pick_by_tracktype->('Lyrics') ],
      '}' ],
  );
};

1;
