# $Id: Track.pm,v 1.6 2012/03/04 11:56:47 je Exp $

package Track;

use Exporter qw(import);
use Fuzz;
use Instrument;
use Moose;

# XXX perhaps a new Mixer class is needed for instruments volumes?

has 'instrument' => (is => 'ro', isa => 'Instrument',       required => 1);
has 'simultence' => (is => 'ro', isa => 'Expr::Simultence', required => 1);
has 'trackname'  => (is => 'ro', isa => 'Str',              required => 1);

sub sequence_ly {
  my ($self, $modes) = @_;
  $self->simultence->track($self->trackname, $self->tracktype)
       ->to_ly($modes);
}

sub to_ly {
  my ($self, $modes) = @_;
  (
    '\new', $self->tracktype, '=', qq{"${\ $self->trackname }"}, '{',
      [ $self->instrument->to_ly($modes) ],

      # XXX workaround a lilypond bug so that volumes can be set
      '<<', '{ s1\p }',
        [ $self->sequence_ly($modes) ],
      '>>',
    '}',
  );
}

sub track {
  my ($class, $mixer, $instrument_name, $trackname, $simultence) = @_;

  my %volumes = map {
    my $volume = $mixer->$_($instrument_name);
    # XXX numify here presumes too much...
    # XXX Instrument should coerce Math::BigFloat (or whatever)
    defined($volume) ? ($_ => $volume->numify) : ();
  } qw(min_volume max_volume);

  my $instrument = Instrument->new(name => $instrument_name,
				   %volumes);

  $class->new(instrument => $instrument,
              simultence => $simultence,
              trackname  => $trackname);}


1;
