# $Id: Song.pm,v 1.14 2012/03/04 17:03:30 je Exp $

package Test::Song;

use bigrat;

use Fuzz;
use Moose;
use Song qw(:all);

no warnings qw(qw);

extends qw(Song);

our %Chords
  = (a => chords { qw( | e2:    a4:m d8:maj7 g8:6 )         },
     b => chords { qw( | e2:    a4:m d8 g8: | a4 )          },
     c => chords { qw( | a4.:m ),  Times(5/8, qw( d1:m )), })
  ;

our $Lyrics
  = lyrics {
      q{ 
	tur-nip-sit tu-le-vat tur-nip-sit tu-le-vat
	tur-nip-sit o-ve-lat  ne tu-le-vat
      } },
  ;

our $Notes
  = notes { qw( | b g' c, f c e ) }
  ;

our %Rhythms = (
  a => rhythm { qw( | 8 16 16    8 16 16 ~    16 16 16 16    16 16 8 ) },
  b => rvec(0xff89),
  c => rvec(0x8f9f, 32),
);

our %Melody = (
  a => melody { qw(c8 d e4 ~    e16 g g c ~ c8. c16) },
  b => melody { c($Notes, $Rhythms{a})  },
);

our %Parts = (
  chords => (parts
	       verse  => $Chords{a},
	       bridge => $Chords{b}),
  melody => (parts
	       verse  => $Melody{a},
	       bridge => $Melody{a}),
);

our $Tagsequences
  = chords {
      _a   => qw( | a4.:m ),  Times(5/8, qw( d1:m )),
      _bc  => qw( | d1:m  ),
      _c   => qw( | a1:m  ),
      _    => qw( | c1:   ), },
  ;

our $Vocals = vocals { v($Melody{a} % 'ab',  $Lyrics % 'a') };

sub make_mixer { {} }

sub make_parts { \%Parts; }

sub make_router {
  verse  => [[ 'a' ],
             [ chords => 'abab', ]],
  bridge => [[ 'c' ]],
  ;
}

sub trackscheme {
  [ 'Track::ChordNames' => organ => 'chords', ],
  [ 'Track::Voice'      => piano => 'melody', ],
  ;
}

1;
