# $Id: Testing.pm,v 1.20 2012/02/26 08:32:37 je Exp $

package Song::Testing;

use bigrat;

use Expr::Sequence::Rhythm;
use Fuzz;
use Moose;
use Song qw(:all);

extends qw(Song);

no warnings qw(qw);

my $rhythmv = rvec(0xffff8989fffff0f1);

our %Grammars = (
  melody => grammar(
    a => [
      [ 'c', S('a'), qw(d e f c g' d a' g) ] => 0.3,
      [ 'a', S('b'), qw(c e f), S('c')     ] => 1.0,
    ],
    b => [
      [ qw(g e g' e, e' e, a f a f), S('c'),     ] => 0.5,
      [ qw(b c b d, e g a c d),      S('c'), 'd' ] => 1.0,
    ],
    c => [
      [ qw(a b)         ] => 0.7,
      [ qw(c d e f d b) ] => 1.0,
    ]),
  rhythm => grammar(
    a => [
      [ '8',  S('a'), qw(8 16 4. 8 8 2 16 16), ] => 0.3,
      [ '16', S('b'), qw(16 16 8 8 16), S('c') ] => 1.0,
    ],
    b => [
      [ qw(16 16 16. 32),  S('b'), qw(32 32 32 32), S('c'), ] => 0.4,
      [ qw(8 16 16 8. 16), S('b'), qw(32 16 32 8),  S('c'), ] => 0.6,
      [ qw(16 16 16. 32),  S('c'), qw(16 8.)                ] => 1.0,
    ],
    c => [
      [ qw(16 16)               ] => 0.65,
      [ qw(8 16 8 16 8 16 8 16) ] => 1.0,
    ]),
);

our $Notes
  = parts
      verse =>
        notes {
          map { (relative q{c'},
                  $Grammars{melody}->produce(S('a'), $_)) } (0 .. 7),
          (relative q{c'},
            qw( | c g' c,        f c e ~    e c e c         e c e c
                | bes f' bes,    e c d ~    d bes d bes     d bes c )) },
      bridge =>
        notesets {
          (relative q{c'},
            qw( | <c_e_g>    <g_b_d> <cis_e_g>
                | <c_e_g>    <g_b_d>           )) },
  ;

our $Rhythms
  = parts
      verse  => $rhythmv,
      bridge =>
        rhythm {
          _  => qw( | 8 16 16    8 16 16 ~    16 16 16 16    16 16       ),
                  map { $Grammars{rhythm}->produce(S('a'), $_) } (0 .. 7),
          _a => qw(                                                16 16 ),
          _b => qw(                                                8     ), },
  ;

our $Melody
  = parts
      verse =>
        melody {
          (relative q{c'},
            (c $Notes, $Rhythms % 'ab')) },
      bridge =>
        polyp {
          (c $Notes, $Rhythms % 'a') },
  ;

sub make_parts {
  {
    melody => $Melody,
  }
}

sub make_router {
  verse  => [[ 'aa' ]],
  # bridge => [[ 'a' ]],
}

sub trackscheme {
  [ 'Track::Voice' => piano => 'melody' ],
  ;
}

1;
