# $Id: HitaatLiikkeet.pm,v 1.9 2012/03/04 11:56:48 je Exp $

package Song::HitaatLiikkeet;

use bigrat;

use Fuzz;
use Moose;
use Song qw(:all);

extends qw(Song);

no warnings qw(qw);

our $Chords
  = parts
      verse =>
        chords {
          (qw( | c4.:  ), Times(5/8, qw( e1:m )))    x 2,
          (qw( | d4.:m ), Times(5/8, qw( f1:  )))    x 2 },
      
      bridge =>
        chords {
          qw( | e2:m     a4 g:
              | f2:      bes
              | ), Times(2, qw( es1 )) },
      
      chorus =>
        chords {
          _abc => qw( | a2:m      d    ),
                  qw( | e         d    ),
                  qw( | a         d    ),
                  qw( | e2.       f4:  ),
          _ac  => qw( | a4.:m ),  Times(5/8, qw( d1:m  )),
                  qw( | e4.:m ),  Times(5/8, qw( f1:   )),
                  qw( | e4.:m ),  Times(5/8, qw( d1:m  )),
                  qw( | c4.:  ),  Times(5/8, qw( bes1: )),
                  qw( | g2.:      e4:m
                      | f2.:      d4:m ),
          _c   => (qw( | c4.: ),  Times(5/8, qw( e1:m )))    x 8 },
  ;

our $Lyrics
  = parts
      verse =>
        lyrics {
          _a => q{
                  ha-lu-an o-rans-sin vil-la-pai-dan
                  ja vai-pu-a trans-siin syk-syn v-reis-t
                  ha-lu-an tak-ka-tu-len ja kir-jan
                  jo-ka ker-too ta-ri-naa ih-mi-sis-t
                },
          _b => q{
                  lu-ki-sin kir-jas-ta ta-ri-naa
                  jos-sa pi-an ker-ron-taa no-peu-te-taan
                  ih-mi-set saa-vat al-kuun mon-ta a-si-aa
                  niin sa-laa et-tei-vt it-se huo-maa
                },
          _c => q{
                  tai-dan nyt u-los men-n sa-tee-seen
                  tut-ki-maan on-ko puis-sa o-me-ni-a
                  ver-kal-leen sa-teen-var-jo-ni al-ta
                  pu-hal-te-li-sin saip-pu-a-kup-li-a
                } },
      
      bridge =>
        lyrics {
          _a => q{
                  o-len-nois-ta jot-ka a-sui-vat
                  pie-nes-s kau-pun-gis-sa
                  vuo-si-sa-to-ja sit-ten
                },
          _b => q{
                  nuo ih-mi-set jot-ka liik-kui-vat
                  ryt-meis-s lii-an kiih-keis-s
                  te-ko-jaan huo-ma-tak-seen
                },
          _c => q{
                  ih-mi-sil-le jot-ka e-li-vt
                  lii-an ly-hy-et e-l-mt
                  nh-dk-seen nii-den jl-jet
                } },
      
      chorus =>
        lyrics {
          _ab => q{
                   hi-taas-ti nos-tan kat-see-ni kir-jas-ta
                   kat-son u-los ik-ku-nas-ta
                   kuin puu-las-tu-nen aal-lon har-jal-la kul-jen
                 },
          _c  => q{
                   lii-kun
                 },
          _ac => q{
                   hi-tai-den liik-kei-den mu-ka-na
                 } },
  ;

our $Melody
  = parts
      verse =>
        melody {
          (relative q{c'},
             _a     => qw( | r1 ) x 4,
             _ace   => qw( | r1 ) x 4,
             
             _      => qw( | g16 a c8 ~       4
                             r2                          ),
             
             _abcef => qw( | r2                          ),
             _d     => qw( | r4               c8 c       ),
             
             _a     => qw( | c16 8 16         8 b16 a ~  ),
             _b     => qw( | c8 16 16 ~       16 b8 16   ),
             _c     => qw( | r8 c             8. b16     ),
             _d     => qw( | c8 c             8. b16     ),
             _e     => qw( | c16 8 16 ~       8 b16 b    ),
             _f     => qw( | c16 8 16 ~       8 b16 b    ),
             
             _abe   => qw( | a8 a ~                      ),
             _cd    => qw( | a16 a 8 ~                   ),
             _f     => qw( | a8. 16 ~                    ),
              _     => qw(                    a4 
                             r4                          ),
               _bce => qw(                    r8  g16 a  ),
               _af  => qw(                    r8. g16    ),
               _d   => qw(                    r8  g8     ),
              
             _a     => qw( | a8 e16 g         c8 b
                             a16 g8 a16       c8 d       ),
             _b     => qw( | e8 g             c16 b a8
                             g8 a16 c ~       8 d        ),
             _c     => qw( | e16 g8 c16 ~     c b8 a16 ~
                             a8 g16 a         c d8.      ),
             _d     => qw( | a16 e8 g16 ~     g c8 b16
                             a8 g16 a16 ~     a c8 d16   ),
             _e     => qw( | e8 g16 c         b8. a16
                             r8 g16 a         c d r8     ),
             _f     => qw( | a8 e16 g         c8 b
                             a16 g8 a16 ~     a c16 d8   )) },

      bridge =>
        melody {
          (relative q{c'},
             _a => qw( | e16 d8 g16 ~          g8 d
                         e8. 16                d16. e32 ~ 16 d
                       | c8 16 d               c8 a
                         g4                    f
                       | es8. 16               16. 32 ~ 16 16
                         bes'8 bes8 ~          4 ~             ),
             _b => qw( | e8 16 d               g8 d16 e ~
                         8 8                   d8. 16
                       | c8 16 d ~             16 c8 a16 ~
                         8 8                   g4
                       | es16 16 8             8 16 bes' ~
                         bes8 8 ~              4 ~             ),
             _c => qw( | e8 d16 g ~            8 d
                         e8. 16                d16. e32 ~ 16 d
                       | r8 c16 d              c16. 32 ~ 16 16
                         a16. 32 ~ 16 g ~      8 r
                       | es8 16 16             8 16 bes' ~
                         bes8 8 ~              4 ~             ),
             _  => qw( | bes2                  r2              )) },

      chorus =>
        melody {
          (relative q{c'},
                    _abc => qw( | g16 a8 g16    a8 c16 d ~
                                  d c8 d16      e16. f32 ~ 16 e
                                | r8 g16 a      e g8.
                                  d8 e16 c ~    16 a16 r g
                                | a8. 16 ~      16 g a c ~
                                  c a8 c16 ~    16 d8 c16        ),
                    
                    _abc => qw( | e8. g16 ~     g4               ),
                     _b  => qw(   r2                             ),
                     _d  => qw(   r4            c8 a             ),
                    
                    _acd => qw(   d16 e8 c16    d8 c16 a 
                                |               g a a8 ~      a4
                                  r2                             ),
                    _a   => qw( | r1 ) x 5                       ) },
  ;

=for comment

  /  = label parts
  %  = take sections with tags
  x  = repeat a sequence
  +  = mix together
  .  = concatenate

=cut

our $Vocals
  = parts
      verse =>
        vocals {
          _a => (v $Melody % 'ab',      $Lyrics % 'a'),
          _b => (v $Melody % 'cd',      $Lyrics % 'b'),
          _c => (v $Melody % 'ef',      $Lyrics % 'c') },
      bridge =>
        vocals {
          _a => (v $Melody % 'a',       $Lyrics % 'a'),
          _b => (v $Melody % 'b',       $Lyrics % 'b'),
          _c => (v $Melody % 'c',       $Lyrics % 'c'), },
      chorus =>
        vocals {
          _a => (v $Melody % 'a',       $Lyrics % 'a'),
          _b => (v $Melody % 'b',       $Lyrics % 'b'),
          _c => (v $Melody % 'cdddddd', $Lyrics % 'acccccc') },
  ;

sub make_mixer {
  {
    organ => { max_volume => 0.7 },
  }
}

sub make_parts {
  {
    chords => $Chords,
    vocals => $Vocals,
  }
}

sub make_router {
  verse     => [[ 'a' ],
                [ chords => 'aaaa' ]],
  bridge    => [[ 'a' ]],
  verse     => [[ 'b' ],
                [ chords => 'bbb' ]],
  bridge    => [[ 'b' ]],
  chorus    => [[ 'a' ]],
  verse     => [[ 'c' ],
                [ chords => 'ccc' ]],
  bridge    => [[ 'c' ]],
  chorus    => [[ 'b' ]],
  chorus    => [[ 'c' ]],
  ;
}

sub tempo { '4=82' }

sub trackscheme {
  [ 'Track::ChordNames' => organ => 'chords' ],
  [ 'Track::Vocals'     => piano => 'vocals' ],
  [ 'Track::Voice'      => organ => 'chords' ],
  ;
}

1;
