# $Id: Song.pm,v 1.14 2012/03/04 17:03:26 je Exp $

package Song;

use Exporter qw(import);
use Expr::Sequence::Rhythm qw(rvec);
use Fuzz;
use Generator::Grammar qw(grammar E S Sl);
use Mixer;
use Moose;
use Parts qw(parts);
use Router qw(router);
use SequenceTag qw(chords lyrics melody notes notesets polyp rhythm vocals);
use SequenceTag::Filter qw(relative Times);

require Track::ChordNames;
require Track::Vocals;
require Track::Voice;

our (%EXPORT_TAGS) = (all => [ qw(c chords E grammar lyrics melody notes
				  notesets parts polyp rhythm relative rvec S
                                  Sl Times v vocals)
		             ]);
Exporter::export_tags('all');

has 'mixer'      => (is      => 'ro',
                     isa     => 'Mixer',
                     builder => '_mixer' );
has 'songparts'  => (is      => 'ro',
                     isa     => 'HashRef[Parts]',
                     builder => '_parts' );
has 'songrouter' => (is      => 'ro',
                     isa     => 'Router',
                     builder => '_router');

sub _mixer  { Mixer->new(volumes => $_[0]->make_mixer)  }
sub _parts  {                       $_[0]->make_parts   }
sub _router {                router($_[0]->make_router) }

sub simultence {
  my ($self) = @_;
  (reduce { $a + $b }
     map { $self->songparts->{ $_ } / $_ }
     keys %{ $self->songparts })
       ->collect_sections($self->songrouter);
}

sub tempo { '4=120' }	# default tempo

sub tracks {
  my ($self) = @_;
  my $simultence = $self->simultence;
  map {
    my ($track_class, $instrument_name, $trackname) = @$_;
    $track_class->track($self->mixer,
			$instrument_name,
			$trackname,
			$simultence);
  } $self->trackscheme;
}

sub c { shift->op(c => @_) }
sub v { shift->op(v => @_) }

1;
