# $Id: Filter.pm,v 1.3 2012/02/01 18:42:10 je Exp $

package SequenceTag::Filter;

use Exporter qw(import);
use Fuzz;
use Moose;

require Filter::Sequence::Relative;
require Filter::Sequence::Times;

our (@EXPORT_OK) = qw(relative Times);

extends qw(SequenceTag);

has 'filter_class' => (is => 'ro', isa => 'ClassName', required => 1);
has 'filter_attrs' => (is => 'ro', isa => 'HashRef'  , required => 1);

sub relative {
  my ($relnote, @tagged_exprs) = @_;
  __PACKAGE__->new(expr_class   => undef,
		   filter_class => 'Filter::Sequence::Relative',
                   filter_attrs => { relnote => $relnote },
                   tagged_exprs => \@tagged_exprs)
}

sub Times {
  my ($time, @tagged_exprs) = @_;
  __PACKAGE__->new(expr_class   => undef,
		   filter_class => 'Filter::Sequence::Times',
                   filter_attrs => { time => $time },
                   tagged_exprs => \@tagged_exprs)
}

sub tagged {
  my ($self, $expr_class, @wanted_tags) = @_;

  my @filters = $self->filter_class->new($self->filter_attrs);
  my @exprs   = $self->sequence_tagged_exprs($self->tagged_exprs,
                                             @wanted_tags);

  $expr_class->new_from_exprs(exprs   => \@exprs,
                              filters => \@filters);
                              
}

1;
