# $Id: SequenceTag.pm,v 1.11 2012/03/04 07:58:53 je Exp $

package SequenceTag;

use Exporter qw(import);
use Fuzz;
use Moose;

require Expr::Delayed;
require Expr::Sequence::Lyrics;
require Expr::Sequence::NoteSets;
require Expr::Sequence::Notes;
require Expr::Sequence::Rhythm;
require Expr::Sequence::WithDuration::Chords;
require Expr::Sequence::WithDuration::Melody;
require Expr::Sequence::WithDuration::Polyphony;
require Expr::Vocal;

our (@EXPORT_OK) = qw(chords lyrics melody notes notesets polyp rhythm vocals);

has 'expr_class'   => (is => 'ro', isa => 'Any'     , required => 1);
has 'tagged_exprs' => (is => 'ro', isa => 'ArrayRef', required => 1);

my %sequencetagfunctions = (
  chords   => 'Expr::Sequence::WithDuration::Chords',
  lyrics   => 'Expr::Sequence::Lyrics',
  melody   => 'Expr::Sequence::WithDuration::Melody',
  notes    => 'Expr::Sequence::Notes',
  notesets => 'Expr::Sequence::NoteSets',
  polyp    => 'Expr::Sequence::WithDuration::Polyphony',
  rhythm   => 'Expr::Sequence::Rhythm',
  vocals   => 'Expr::Vocal',
);
while (my ($fnname, $class) = each %sequencetagfunctions) {
  no strict 'refs';
  *{ $fnname } = sub (&) {
                   Expr::Delayed->new(coderef => sequencetagfunc($class, @_))
		 };
}

sub expr {
  my ($self, %context) = @_;
  my $tags = $context{tags} // '_';
  $self->tagsequence(parse_tagstring($tags));
}

sub find_matched_exprs {
  my ($self, $wanted_tag) = @_;
  my @matched_exprs;

  my @expr_tags = qw(_);
  foreach my $element (@{ $self->tagged_exprs }) {
    if ($element =~ m/^_(?<tagstring>.*)/) {
      my @prefixed_tags = map { "_$_" } split(//, $+{tagstring});
      @expr_tags        = @prefixed_tags ? @prefixed_tags : '_';
    }
    elsif ($wanted_tag ~~ @expr_tags || [ qw(_) ] ~~ @expr_tags) {
      push(@matched_exprs, $element);
    }
  }

  @matched_exprs;
}

sub parse_tagstring { split(//, $_[0]); }

# XXX is "tagged" just another kind of a filter?

sub sequence_tagged_exprs {
  my ($self, $expr_class, @wanted_tags) = @_;

  map {
    my $tag   = $_;
    my @exprs = $self->find_matched_exprs($_);

    map {
      ref($_) && $_->isa('SequenceTag')
        ? $_->tagged($expr_class, $tag)
        : $_
    } @exprs;

  } @wanted_tags;
}

sub sequencetagfunc {
  my ($expr_class, $fn) = @_;
  fn {
    __PACKAGE__->new(expr_class   => $expr_class,
                     tagged_exprs => [ $fn->() ]);
  };
}

sub tagged {
  my ($self, $expr_class, @wanted_tags) = @_;
  my @exprs = $self->sequence_tagged_exprs($expr_class,
                                           @wanted_tags);
  $expr_class->new_from_exprs(exprs => \@exprs);
}

sub tagsequence {
  my ($self, @unprefixed_wanted_tags) = @_;
  my @wanted_tags = map { '_' . $_ } @unprefixed_wanted_tags;
  $self->tagged($self->expr_class,
                @wanted_tags ? @wanted_tags : '_');
}

1;
