# $Id: Score.pm,v 1.8 2012/03/03 07:38:56 je Exp $

package Score;

use Carp;
use Exporter qw(import);
use Fuzz;
use Ly::Mode;
use Moose;

our (@EXPORT_OK) = qw(lilypond);

has 'tempo'  => (is => 'ro', isa => 'Str',             required => 1);
has 'tracks' => (is => 'ro', isa => 'ArrayRef[Track]', required => 1);

sub ly_atoms_to_text_r {
  my ($self, $depth, @ly_atoms) = @_;
  ("\n",
   ' ' x (2 * $depth),
   map {
     ref($_) eq 'ARRAY'
       ? $self->ly_atoms_to_text_r($depth + 1, @$_)
       : (' ', $_)
   } @ly_atoms,
  "\n");
}

sub ly_atoms_to_text {
  my ($self, @ly_atoms) = @_;
  (join '' =>
        remove_duplicate_whitespace($self->ly_atoms_to_text_r(0, @ly_atoms)));
}

sub lilypond {
  my ($scorename, $song) = @_;
  my @tracks = $song->tracks;
  my $new = __PACKAGE__->new(tempo  => $song->tempo,
			     tracks => \@tracks);
  $new->write_and_run_lilypond($scorename);
}

sub remove_duplicate_whitespace {
  my $prev_atom = $_[0];
  grep {
    my $pass = (not ($_ ~~ [ ' ', "\n", ]))
                 || ($_ ne $prev_atom);
    $prev_atom = $_;
    $pass;
  } @_;
}

sub run_lilypond {
  my ($self, $scorepath) = @_;
  system(qw(lilypond --ps --output), $scorepath, "$scorepath.ly") == 0
    or "error when executing lilypond";
}

sub score {
  my ($self) = @_;
  
  my @ly_atoms = (
    [ '\version', q{"2.14.2"}, ],
    [
      '\score', '{',
        [ '<<',
            [ '\tempo', $self->tempo, ],
            [ map { $_->to_ly(Ly::Mode->new(modes => {})) }
                  @{ $self->tracks } ],
          '>>' ],
        [ '\layout', '{}', ],
        [ '\midi',   '{}', ],
      '}' ],
    );
  $self->ly_atoms_to_text(@ly_atoms);
}

sub write_and_run_lilypond {
  my ($self, $scorename) = @_;
  my $scorepath = "scores/$scorename";
  my $score = apply { utf8::encode($_) } $self->score;
  $self->write_to_file("$scorepath.ly", $score);
  $self->run_lilypond($scorepath);
}

sub write_to_file {
  my ($self, $scorepath, $score) = @_;
  open(my $ly_file, '>', $scorepath)
    or croak "could not open $scorepath: $!";
  print $ly_file $score
    or croak "could not write to $scorepath";
  close($ly_file)
    or carp "could not close $scorepath: $!";
}

1;
