# $Id: Router.pm,v 1.3 2012/02/01 18:42:07 je Exp $

package Router;

use Exporter qw(import);
use Fuzz;
use Moose;
use Route;

has routes => (is => 'ro', isa => 'ArrayRef[Route]', required => 1);

our (@EXPORT_OK) = qw(router);

sub router {
  my (@routemaps) = @_;
  my @routes;

  my $it = natatime(2, @routemaps);
  while (my ($section, $map) = $it->()) {
    push @routes, Route->new(map => $map, section => $section);
  }
  __PACKAGE__->new(routes => \@routes);
}

1;
