# $Id: Route.pm,v 1.5 2012/02/19 17:52:02 je Exp $

package Route;

use Fuzz;
use Moose;

has 'map'     => (is => 'ro', isa => 'Any', required => 1);
has 'section' => (is => 'ro', isa => 'Str', required => 1);

sub section_and_tags {
  my ($self, $label) = @_;

  my $section = $self->section;
  my $tags    = '_';
  foreach my $mapitem (@{ $self->map }) {
    given (scalar(@$mapitem)) {
      when (1) { $tags = $mapitem->[0]; }
      when (2) { if ($mapitem->[0] eq $label) { $tags = $mapitem->[1]; } }
      when (3) { if ($mapitem->[0] eq $label) {
                   ($section, $tags) = @$mapitem[1,2]
                 }
               }
    }
  }

  ($section, $tags);
}

1;
