# $Id: Parts.pm,v 1.15 2012/03/04 07:58:53 je Exp $

package Parts;

use feature qw(switch);
use overload '/'      => \&with_label,
             '%'      => \&with_tags,
             fallback => 1,
             ;

use Exporter qw(import);
use Fuzz;
use Moose;
use PartSet;

our (@EXPORT_OK) = qw(parts);

has 'sections' => (is => 'ro', isa => 'HashRef', required => 1);

sub expr {
  my ($self, %context) = @_;
  my $section = $context{section} // '_';
  my $section_expr = $self->sections->{ $section };

  if (not defined $section_expr) {
    confess("$self is missing section '$section'");
  }

  $section_expr->expr(%context);
}

sub parts {
  my (%partnames_and_music_exprs) = @_;
  __PACKAGE__->new(sections => \%partnames_and_music_exprs);
}

sub with_label {
  my ($self, $label) = @_;
  PartSet->new(parts => { $label => $self });
}

sub with_tags {
  my ($self, $tags) = @_;
  Expr::Delayed->new(coderef => fn { $self },
		     context => { tags => $tags });
}

1;
