# $Id: PartSet.pm,v 1.5 2012/02/24 19:39:05 je Exp $

package PartSet;

use overload '+' => \&add,
    fallback     => 1;

use Expr::Simultence;
use Fuzz;
use Moose;

has 'parts' => (is => 'ro', isa => 'HashRef[Parts]', required => 1);

sub add {
  my ($self, $another_partset) = @_;  
  $self->new(parts => { %{ $self->parts },
                        %{ $another_partset->parts }, });
}

sub collect_sections {
  my ($self, $router) = @_;
  my @simultences;

  foreach my $route (@{ $router->routes }) {
    my %exprs_by_label;
    while (my ($label, $part) = each %{ $self->parts }) {
      my ($section, $tags) = $route->section_and_tags($label);
      $exprs_by_label{ $label } = $part->expr(section => $section,
					      tags    => $tags);
    }
    push @simultences,
         Expr::Simultence->new(tracks => \%exprs_by_label);
  }

  reduce { $a . $b } @simultences;
}

1;
