# $Id: Mode.pm,v 1.4 2012/02/01 18:42:10 je Exp $

package Ly::Mode;

use Fuzz;
use Moose;

extends qw(Ly);

with qw( MooseX::Clone );

has 'modes' => (is => 'ro', isa => 'HashRef', required => 1);

sub modestring {
  my ($self, $mode, @modifiers) = @_;
  @modifiers
    ? "$mode @modifiers"
    : $mode;
}

sub to_ly {
  my ($self, $mode, @modifiers) = @_;
  my $modestring = $self->modestring($mode, @modifiers);
  $self->modes->{ $modestring }
    ? ()
    : "\\$modestring";
}

sub with_mode {
  my ($self, $mode, @modifiers) = @_;  
  my $modestring = $self->modestring($mode, @modifiers);
  $self->clone(modes => { %{ $self->modes }, $modestring => 1 });
}

1;
