# $Id: Instrument.pm,v 1.5 2012/03/04 17:03:26 je Exp $

package Instrument;

use Fuzz;
use Moose;
use Readonly;

has 'max_volume' => (is => 'ro', isa => 'Num', default  => 1.0);
has 'min_volume' => (is => 'ro', isa => 'Num', default  => 0.0);
has 'name'       => (is => 'ro', isa => 'Str', required => 1  );

our Readonly %midinames = (
  organ   => 'drawbar organ',
  piano   => 'acoustic grand',
  strings => 'string ensemble 1',
);

sub midiname { $midinames{ $_[0]->name } }

sub to_ly {
  my ($self) = @_;
  $self->midiname
    ? ([ qw(\set Staff.midiInstrument =), qq{"${\ $self->midiname }"} ],
       [ qw(\set Staff.midiMinimumVolume =),
            qq{#${\ sprintf("%.2f", $self->min_volume) }} ],
       [ qw(\set Staff.midiMaximumVolume =),
            qq{#${\ sprintf("%.2f", $self->max_volume) }} ])
    : ();

}

1;
