# $Id: Random.pm,v 1.2 2012/02/26 09:01:00 je Exp $

package Generator::Random;

use Fuzz;
use Math::BigInt;
use Moose;
use Readonly;

has 'X' => (is => 'rw', isa => 'Math::BigInt', required => 1);

Readonly my $a => Math::BigInt->new('3141592621');
Readonly my $c => Math::BigInt->new('1');
Readonly my $m => Math::BigInt->new('2') ** 32;

sub seed {
  my ($class, $seed) = @_;
  $class->new(X => Math::BigInt->new($seed));
}

sub next {
  my ($self) = @_;
  $self->X( ($a * $self->X + $c) % $m );
  ($self->X / $m)->numify;
}

1;
