# $Id: Symbol.pm,v 1.2 2012/03/03 19:20:47 je Exp $

package Generator::Grammar::Symbol;

use overload '/'      => \&with_label,
             fallback => 1;

use Fuzz;
use Moose;

require Generator::Grammar::Symbol::Labeled;

has 'symbol' => (is => 'ro', isa => 'Str', required => 1);

sub with_label {
  my ($self, $label) = @_;
  Generator::Grammar::Symbol::Labeled->new(label  => $label,
					   symbol => $self->symbol);
}

1;
