# $Id: Grammar.pm,v 1.12 2012/03/04 17:03:29 je Exp $

package Generator::Grammar;

use Exporter qw(import);
use Fuzz;
use Generator::Grammar::Symbol;
use Generator::Random;
use Moose;
use Tie::RefHash;

our (@EXPORT_OK) = qw(grammar E S Sl);

has 'spec' => (is => 'ro', isa => 'HashRef', required => 1);

sub grammar {
  my (%spec) = @_;
  $spec{ $_ } = tiehash(@{ $spec{ $_ } }) foreach keys %spec;
  __PACKAGE__->new(spec => \%spec);
}

sub produce {
  my ($self, $initial, $randseed, $process_choice) = @_;

  my $randgen = Generator::Random->seed($randseed);
  my %exprs_by_label;

  $self->produce_r([ $initial ], \%exprs_by_label, $randgen, $process_choice);
}

sub produce_r {
  my ($self, $text, $exprs_by_label, $randgen, $process_choice) = @_;
  my @output;

  for my $expr (@$text) {
    if (blessed($expr) && $expr->isa('Generator::Grammar::Symbol')) {
      my $sym  = $expr;
      my $rand = $randgen->next;

      my $process_symbol_fn
        = fn {
	    my @out = $self->process_symbol($rand, $sym, $process_choice);
	    $self->produce_r(\@out,
			     $exprs_by_label,
			     $randgen,
			     $process_choice);
          };

      push @output,
	   @{
	     $sym->can('label')
	       ? ($exprs_by_label->{ $sym->label }
		   //= [ $process_symbol_fn->() ])
	       : [ $process_symbol_fn->() ]
	   };
    }
    else {
      push @output, $expr;
    }
  }

  @output;
}

sub process_symbol {
  my ($self, $rand, $sym, $process_choice) = @_;

  my $sym_spec = $self->spec->{ $sym->symbol };

  my @choices = sort { $sym_spec->{ $a } <=> $sym_spec->{ $b } }
                  keys %$sym_spec;
  my ($choice) = (first { $rand < $sym_spec->{ $_ } } @choices)
                   || $choices[-1];

  $process_choice->($choice);
}

sub E ($) { [ split(' ', $_[0]) ] }

sub S ($) { Generator::Grammar::Symbol->new(symbol => $_[0]); }

sub Sl {
  my ($symbol, @labels) = @_;
  map { S($symbol) / $_ } @labels;
}

sub tiehash { tie my %h, 'Tie::RefHash'; %h = @_; \%h; }

1;
