# $Id: Fuzz.pm,v 1.7 2012/03/04 17:03:26 je Exp $

package Fuzz;

use feature qw(say switch);
use strict;
use warnings;

use Data::Dumper;
use Exporter;
use List::MoreUtils qw(all any apply firstidx natatime pairwise uniq);
use List::Util qw(first max min reduce);

our (@ISA   ) = qw(Exporter);
our (@EXPORT) = qw(all any apply first firstidx fn max min natatime reduce p
		   pairwise pp ppp uniq);

sub import {
  feature->import(qw(say switch));
  strict->import;
  warnings->import;
  __PACKAGE__->export_to_level(1, @_);
}

sub fn (&) { $_[0] }

sub p {
  my ($data, %attrs) = @_;

  local $Data::Dumper::Indent   = $attrs{indent} // 2;
  local $Data::Dumper::Maxdepth = $attrs{depth}  // 1;
  print Dumper($data);
}

sub pp  { p(@_, depth => 2); }
sub ppp { p(@_, depth => 3); }
