# $Id: Times.pm,v 1.4 2012/02/01 18:42:10 je Exp $

package Filter::Sequence::Times;

use Fuzz;
use Ly::Mode;
use Moose;

extends qw(Filter::Sequence);

has 'time' => (is       => 'ro',
               isa      => 'Any', # may be a Math::BigRat or something else
               required => 1);

sub to_ly_mode {
  my ($self) = @_;
  my $timefmt = int($self->time) == $self->time
                  ? "${\ $self->time }/1"
                  : $self->time;
  ('times', $timefmt);
}

1;
