# $Id: Polyphony.pm,v 1.6 2012/03/04 07:58:57 je Exp $

package Expr::WithDuration::Polyphony;

use Expr::Duration;
use Expr::NoteSet;
use Expr::WithDuration::Note;
use Fuzz;
use Moose;

extends qw(Expr::WithDuration);

# XXX needs another type, something like Expr::NoteSet|Expr::RepeatPrev ?
has 'notes' => (is => 'ro', isa => 'Maybe[Expr::NoteSet]', required => 1);

override 'musicattrs' => fn { (super, 'notes') };

sub parse_ly {
  my ($class, $ly_text) = @_;

  $ly_text =~ m/
                ( ?<notes>    < .*? >  ) ?
                ( ?<duration> (\d+\.*) ) ?
              /gmx;

  if (not $+{notes} and not $+{duration}) {
    return Expr::WithDuration::Note->parse_ly($ly_text);
  }

  $class->new(duration => ($+{duration}
                             ? Expr::Duration->parse_ly($+{duration})
                             : undef),
              notes    => ($+{notes}
                             ? Expr::NoteSet->parse_ly($+{notes})
                             : undef));
}

sub to_ly {
  my ($self) = @_;
  '<'
  . $self->notes->to_ly
  . '>'
  . $self->duration->to_ly;
}

1;
