# $Id: Note.pm,v 1.8 2012/03/04 07:58:57 je Exp $

package Expr::WithDuration::Note;

use Expr::Duration;
use Expr::Note;
use Fuzz;
use Moose;

extends qw(Expr::WithDuration);

# XXX needs another type, something like Expr::Note|Expr::RepeatPrev ?
has 'note' => (is => 'ro', isa => 'Maybe[Expr::Note]', required => 1);

override 'musicattrs' => fn { (super, 'note') };

sub match {
  my ($self, $another) = @_;
  my $to_match;
  given ($another->blessed) {
    when ('Expr::WithDuration::Chord'  ) { $to_match = $another->noteset; }
    when ('Expr::WithDuration::Note'   ) { $to_match = $another->note;    }
    when ('Expr::WithDuration::NoteSet') { $to_match = $another->notes;   }
    default                              { $self->match_error($another)   }
  }
  $self->note ~~ $to_match;
}

sub parse_ly {
  my ($class, $ly_text) = @_;
  $ly_text =~ m/
		(?<note>[[:alpha:]]*[,']*)
		(?<duration>(\d+\.*)?)
              /gmx;

  $class->new(duration => ($+{duration}
                             ? Expr::Duration->parse_ly($+{duration})
                             : undef),
              note     => $+{note}
                             ? Expr::Note->parse_ly($+{note})
                             : undef);
}

sub to_ly {
  my ($self) = @_;
  if (not defined $self->note) { confess 'Note not defined'; }

  $self->note->to_ly
  . $self->duration->to_ly;
}

1;
