# $Id: Chord.pm,v 1.12 2012/03/06 19:46:40 je Exp $

package Expr::WithDuration::Chord;

use Fuzz;
use Moose;

extends qw(Expr::WithDuration);

# XXX change later to type note or some such?
# XXX needs another type, something like Str|Expr::RepeatPrev ?
has 'basenote' => (is => 'ro', isa => 'Maybe[Str]', required => 1);
has 'modifier' => (is => 'ro', isa => 'Maybe[Str]', required => 1);

override 'musicattrs' => fn { qw(basenote duration modifier) };

sub noteset {
  my ($self) = @_;

  if ($self->basenote eq 'r') {
    return Expr::NoteSet->new(notes => []);
  }

  my @notering_is = qw(c cis d dis e f fis g gis a ais b);
  my @notering_es = qw(c des d es  e f ges g aes a bes b);

  my ($base_index, $notering);
  foreach my $tmp_notering (\@notering_is, \@notering_es) {
    $base_index = firstidx { $self->basenote eq $_ } @$tmp_notering;
    if ($base_index >= 0) {
      $notering = $tmp_notering;
      last;
    }
  }
  if (not $notering) { confess 'Could not find notering for noteset'; }

  my %chord_modifiers = (
    '5'        => [ 0, 4, 7,                 ],
    ''         => [ 0, 4, 7,                 ],
    'm'        => [ 0, 3, 7,                 ],
    'm5'       => [ 0, 3, 7,                 ],
    'aug'      => [ 0, 4, 8,                 ],
    'dim'      => [ 0, 3, 6,                 ],
    '7'        => [ 0, 4, 7, 10,             ],
    'maj7'     => [ 0, 4, 7, 11,             ],
    'maj'      => [ 0, 4, 7, 11,             ],
    'm7'       => [ 0, 3, 7, 10,             ],
    'dim7'     => [ 0, 3, 6,  9,             ],
    'aug7'     => [ 0, 4, 8, 10,             ],
    'm7.5-'    => [ 0, 3, 6, 10,             ],
    'm7+'      => [ 0, 3, 7, 11,             ],
    '6'        => [ 0, 4, 7,  9,             ],
    'm6'       => [ 0, 3, 7,  9,             ],
    '9'        => [ 0, 4, 7, 10, 14,         ],
    'maj9'     => [ 0, 4, 7, 11, 14,         ],
    'm9'       => [ 0, 3, 7, 10, 14,         ],
    '11'       => [ 0, 4, 7, 10, 14, 17,     ],
    'maj11'    => [ 0, 4, 7, 11, 14, 17,     ],
    'm11'      => [ 0, 3, 7, 10, 14, 17,     ],
    '13'       => [ 0, 4, 7, 10, 14,     21, ],
    '13.11'    => [ 0, 4, 7, 10, 14, 17, 21, ],
    'maj13.11' => [ 0, 4, 7, 11, 14, 17, 21, ],
    'm13.11'   => [ 0, 3, 7, 10, 14, 17, 21, ],
    'sus2'     => [ 0, 2, 7,                 ],
    'sus4'     => [ 0, 2, 7,                 ],
    '1.5'      => [ 0,    7,                 ],
    '1.5.8'    => [ 0,    7,   12,           ],
  );
  
  my $note_numbers = $chord_modifiers{ $self->modifier };
  if (not $note_numbers) { confess "Could not find note numbers for $self"; }

  my @notes
    = map {
	my $note_i = ($base_index + $_) % @$notering;
	Expr::Note->new(modifier => '',
			note     => $notering->[ $note_i ]);
      } @$note_numbers;

  Expr::NoteSet->new(notes => \@notes);
}

sub parse_ly {
  my ($class, $ly_text) = @_;
  $ly_text =~ m/
		(?<basenote>[[:alpha:]]*)
		(?<duration>(\d+\.*)?)
		(:(?<modifier>\w*))?
              /gmx;

  $class->new(basenote => $+{basenote} || undef,
	      duration => ($+{duration}
                             ? Expr::Duration->parse_ly($+{duration})
                             : undef),
	      modifier => $+{modifier},
             );
}

sub to_ly {
  my ($self) = @_;
  $self->basenote
  . ($self->duration ? $self->duration->to_ly : '')
  . ($self->modifier ? ":${\ $self->modifier }" : '');
}

1;
