# $Id: WithDuration.pm,v 1.6 2012/02/26 12:28:36 je Exp $

package Expr::WithDuration;

use Fuzz;
use Moose;

extends qw(Expr);

with qw( MooseX::Clone );

has 'duration' => (is => 'ro', isa => 'Maybe[Expr::Duration]', required => 1);

sub inherit_musicattrs {
  my ($self, $inherit_from) = @_;

  $self->clone(
    map {
      $self->can($_) && !defined($self->$_) && defined($inherit_from->$_)
        ? ($_ => $inherit_from->$_)
        : ()
    } $inherit_from->musicattrs);
}

sub join {
  my ($self, $joined) = @_;
  $self->clone(duration => $self->duration + $joined->duration);
}

sub musicattrs { qw(duration) }

1;
