# $Id: Vocal.pm,v 1.6 2012/02/25 15:45:07 je Exp $

package Expr::Vocal;

use Fuzz;
use Moose;

extends qw(Expr);

with qw( MooseX::Clone );

has 'lyrics' => (is       => 'ro',
                 isa      => 'Expr::Sequence::Lyrics',
                 required => 1);
has 'melody' => (is       => 'ro',
                 isa      => 'Expr::Sequence::WithDuration::Melody',
                 required => 1);

sub concatenate {
  my ($self, $another) = @_;
  $self->clone(lyrics => ($self->lyrics . $another->lyrics),
               melody => ($self->melody . $another->melody));
}

# XXX should you use coercion instead of this wrapper function?
sub new_from_exprs {
  my ($class, %attrs) = @_;
  $attrs{exprs}->[0];   # XXX not stylish
}

sub track {
  my ($self, $trackname, $tracktype) = @_;
  given ($tracktype) {
    when ('Lyrics') { return $self->lyrics                             }
    when ('Voice')  { return $self->melody                             }
    default         { confess("tracktype $tracktype is not supported") }
  }
}

1;
