# $Id: Simultence.pm,v 1.5 2012/02/25 15:45:07 je Exp $

package Expr::Simultence;

use Fuzz;
use Moose;

extends qw(Expr);

has 'tracks' => (is => 'ro', isa => 'HashRef[Expr]', required => 1);

sub concatenate {
  my ($self, $another) = @_;

  my %tracks =
    map {
      my $one = $self->tracks->{ $_ };
      my $two = $another->tracks->{ $_ };

      $_ =>
        ($one && $two ? ($one . $two) :
         $one         ? $one          : $two);
    }
    uniq(map { keys %{ $_->tracks } } ($self, $another));

  bless($self)->new(tracks => \%tracks);
}

sub track {
  my ($self, $name, $type) = @_;
  my $track = $self->tracks->{ $name };
  $track->track($name, $type);
}

1;
