# $Id: Melody.pm,v 1.7 2012/03/04 17:03:27 je Exp $

package Expr::Sequence::WithDuration::Melody;

use Expr::Vocal;
use Fuzz;
use Moose;

extends qw(Expr::Sequence::WithDuration);

sub match {
  my ($self, $to_match) = @_;
  my %total_durations = (
    match    => Expr::Duration->new(length => 0),
    self     => Expr::Duration->new(length => 0),
    to_match => Expr::Duration->new(length => 0),
  );

  # XXX this function is a mess with no logic...
  my $traverse_fn = fn {
      map {
	$_->isa('Expr::Sequence')
	  ? $_->expr->complete->joined_elements 
	  : $_
      } map { $_->expr->complete->joined_elements } @_,
  };

  my %elements = (
    self     => [ $self    ->traverse_element_tree($traverse_fn) ],
    to_match => [ $to_match->traverse_element_tree($traverse_fn) ],
  );

  my ($i, $j) = (0, 0);
  while ($i <= $#{ $elements{self} } && $j <= $#{ $elements{to_match} }) {
    my $self_expr     = $elements{self    }->[ $i ];
    my $to_match_expr = $elements{to_match}->[ $j ];

    my %starts = (
      self     => $total_durations{self},
      to_match => $total_durations{to_match},
    );
    my %ends = (
      self     => $starts{self}     + $self_expr->duration,
      to_match => $starts{to_match} + $to_match_expr->duration,
    );

    my $common_end   = min(@ends{   qw(self to_match) });
    my $common_start = max(@starts{ qw(self to_match) });

    if ($common_start < $common_end  &&  $self_expr ~~ $to_match_expr) {
      my $length = $common_end->length - $common_start->length;
      $total_durations{match} += Expr::Duration->new(length => $length);
    } 

    if ($ends{self} <= $ends{to_match}) {
      $total_durations{self} += $self_expr->duration; 
      $i++;
    }
    else {
      $total_durations{to_match} += $to_match_expr->duration; 
      $j++;
    }
  }

  my $max_total = max(@total_durations{ qw(self to_match) });
  $max_total && $max_total->length
    ? $total_durations{match}->length / $max_total->length
    : 0;
}

sub seqitemclass { 'Expr::WithDuration::Note'; }

sub v {
  my ($self, $lyrics) = @_;
  Expr::Vocal->new(lyrics => $lyrics, melody => $self);
}

1;
