# $Id: Rhythm.pm,v 1.5 2012/02/26 08:32:36 je Exp $

package Expr::Sequence::Rhythm;

use bigrat;

use Exporter qw(import);
use Fuzz;
use Moose;

our (@EXPORT_OK) = qw(rvec);

extends qw(Expr::Sequence);

sub rvec { __PACKAGE__->vec(@_); }

sub seqitemclass { 'Expr::Duration'; }

sub vec {
  my ($class, $vecspec, $inv_base) = @_;
  my $base = $inv_base ? 1/$inv_base : 1/16;

  my @bits;
  for (; $vecspec; $vecspec = $vecspec >> 1) {
    unshift @bits, ($vecspec & 1);
  }
  my @indexes_with_bit_set = ((grep {  $bits[ $_ ]  } (0 .. $#bits)),
                              scalar(@bits));

  my @timings;
  for (my $i = 1; $i <= $#indexes_with_bit_set; $i++) {
    push @timings,
         ($indexes_with_bit_set[ $i ] - $indexes_with_bit_set[ $i-1 ]);
  }

  my @durations
    = map {
        my $length = ($_ * $base)->numify;
        $class->seqitemclass->new(length => $length);
      } @timings;

  $class->new(elements => \@durations,
              filters  => []);
}

1;
