# $Id: Lyrics.pm,v 1.6 2012/03/04 07:58:55 je Exp $

package Expr::Sequence::Lyrics;

use Expr::Word;
use Fuzz;
use Moose;

extends qw(Expr::Sequence);

sub parse_ly {
  my ($class, $ly_exprs) = @_;

  my $text = join(' ' => @$ly_exprs);
  $text =~ s/^\s+//;
  $text =~ s/\s+$//;

  map { Expr::Word->new(syllables => [ split(/-/, $_) ]) }
      split(/\s+/, $text);
}

# XXX these modeful to_ly -things should be brought together somehow
override to_ly => fn {
  my ($self, $modes) = @_;
  ($modes->to_ly('lyricmode'),
   [ $self->SUPER::to_ly($modes->with_mode('lyricmode')) ]);
};

1;
