# $Id: Sequence.pm,v 1.13 2012/03/04 07:58:54 je Exp $

package Expr::Sequence;

use Expr::Barcheck;
use Expr::Join;
use Expr::WithDuration::Chord;
use Expr::WithDuration::Note;
use Expr::WithDuration::Polyphony;
use Fuzz;
use Moose;

extends qw(Expr);

with qw( MooseX::Clone );

has 'elements' => (is => 'ro', isa => 'Any', required => 1);
has 'filters'  => (is => 'ro', isa => 'ArrayRef[Filter::Sequence]');
                  # XXX filters could be just singular?

sub c {
  my ($self, $rhythm) = @_;
  my $ri = 0;
  my $inc_ri = fn {
    my $old_ri = $ri;
    $ri = ($ri + 1) % scalar(@{ $rhythm->elements });
    $old_ri;
  };

  $self->traverse_element_tree(fn {
    my ($self) = @_;
    push my @non_durations, $rhythm->elements->[ $inc_ri->() ]
      until $rhythm->elements->[ $ri ]->isa('Expr::Duration');

    (@non_durations,
     $self->can('attach_duration')
       ? $self->attach_duration($rhythm->elements->[ $inc_ri->() ])
       : ());
  });
}

sub complete {
  my ($self) = @_;

  my (@complete_elements, %prev_musicexprs_by_type);
  foreach my $element (@{ $self->elements }) {
    my $next_element;
    my $element_class = blessed($element);

    for my $prev_musicexpr ($prev_musicexprs_by_type{ $element_class }) {
      if ($element_class && $element->can('complete')) {
        $next_element = $element->complete;
      }
      elsif ($element_class && $element->can('inherit_musicattrs')) {
        $prev_musicexpr
          = $next_element
            = $prev_musicexpr
                ? $element->inherit_musicattrs($prev_musicexpr)
                : $element;
      }
      else {
        $next_element = $element;
      }
      push @complete_elements, $next_element;
    }
  }

  $self->clone(elements => \@complete_elements);
}

sub concatenate {
  my ($self, $another_sequence) = @_;
  $self->clone(elements => [ $self, $another_sequence ]);
}

sub elements_to_ly {
  my ($self, $modes) = @_;
  ('{',
     (map { $_->to_ly($modes) } @{ $self->complete->elements }),
   '}');
}

sub joined_elements {
  my ($self) = @_;

  my @joined;
  my $join = 0;
  my $prev_musicexpr;

  foreach my $expr (@{ $self->elements }) {
    if ($expr->isa('Expr::Join')) {
      $join = $prev_musicexpr ? 1 : 0;
    }
    elsif ($expr->isa('Expr')) {
      if ($prev_musicexpr) {
        if ($join) {
          $prev_musicexpr = $prev_musicexpr->join($expr);
          $join = 0;
        }
        else {
          push @joined, $prev_musicexpr;
          $prev_musicexpr = $expr;
        }
      }
      else {
        $prev_musicexpr = $expr;
      }
    }
  }
  push(@joined, $prev_musicexpr) if $prev_musicexpr;

  @joined;
}

# XXX should you use coercion instead of this wrapper function?
sub new_from_exprs {
  my ($class, %attrs) = @_;
  my $elements = [ $class->parse_ly(delete $attrs{exprs}) ];
  $class->new(elements => $elements, %attrs);
}

sub parse_ly {
  my ($class, $ly_exprs) = @_;
  map { $class->parse_ly_sequence_item($_) } @$ly_exprs;
}

sub parse_ly_sequence_item {
  my ($class, $ly_expr) = @_;

  return $ly_expr if ref($ly_expr) && $ly_expr->isa('Expr');

  my $expr;
  given ($ly_expr) {
    when ('|') { $expr = Expr::Barcheck->new;                      }
    when ('~') { $expr = Expr::Join->new;                          }
    default    { $expr = $class->seqitemclass->parse_ly($ly_expr); }
  }

  $expr;
}

sub tag {
  my ($self, $tags) = @_;
  Expr::Delayed->new(coderef => fn { $self->expr(@_, tags => $tags); });
}

sub to_ly_with_filters {
  my ($self, $modes, @filters) = @_;
  my ($next_filter, @other_filters) = @filters;

  $next_filter ? $next_filter->to_ly($modes, $self, @other_filters)
               : $self->elements_to_ly($modes);
}

sub to_ly {
  my ($self, $modes) = @_;
  $self->to_ly_with_filters($modes, @{ $self->filters || [] });
}

sub traverse_element_tree {
  my ($self, $fn) = @_;
  map {
    my $element = $_;
    $element->can('traverse_element_tree')
      ? $element->traverse_element_tree($fn)
      : $fn->($element)
  } @{ $self->elements };
}

1;
