# $Id: NoteSet.pm,v 1.6 2012/02/28 18:03:06 je Exp $

package Expr::NoteSet;

use Expr::Note;
use Fuzz;
use Moose;

extends qw(Expr);

has 'notes' => (is => 'ro', isa => 'ArrayRef[Expr::Note]', required => 1);

sub attach_duration {
  my ($self, $duration) = @_;
  Expr::WithDuration::Polyphony->new(duration => $duration,
                                     notes    => $self);
}

sub parse_ly {
  my ($class, $ly_text) = @_;
  my @notes_ly = ($ly_text =~ m/ ([[:alpha:]]+ [,']*) /gmx);

  # XXX this should perhaps be handled by some other way,
  # XXX but for now this is not a supported syntax
  if (not @notes_ly) { confess('Parsed noteset is empty'); }

  $class->new(notes => [ map { Expr::Note->parse_ly($_) } @notes_ly ]);
}

sub to_ly {
  my ($self) = @_;
  join ' ' => map { $_->to_ly } @{ $self->notes };
}

1;
