# $Id: Note.pm,v 1.10 2012/03/06 19:46:39 je Exp $

package Expr::Note;

use Expr::WithDuration;
use Fuzz;
use Moose;

extends qw(Expr);

has 'modifier' => (is => 'ro', isa => 'Str', required => 1);
has 'note'     => (is => 'ro', isa => 'Str', required => 1);

sub attach_duration {
  my ($self, $duration) = @_;
  Expr::WithDuration::Note->new(duration => $duration,
                                note     => $self);
}

sub match {
  my ($self, $another) = @_;
  my $type = $another->blessed;
  $type eq 'Expr::Note'
    ? $self->note eq $another->note :
  $type eq 'Expr::NoteSet'
    ? ((any { $self->note eq $_->note } @{ $another->notes })
         || ($self->note eq 'r'  &&  scalar(@{ $another->notes }) == 0))
    : confess("Matching $self against $another is not defined");
}

sub parse_ly {
  my ($class, $ly_text) = @_;
  $ly_text =~ m/ (?<note>[[:alpha:]]*) (?<modifier>[,']*) /gmx;
  $class->new(modifier => $+{modifier},
	      note     => $+{note});
}

sub to_ly {
  my ($self) = @_;
  $self->note . $self->modifier;
}

1;
